/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.state;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.vremanagement.resourcemanager.impl.reporting.Session;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResource;
import org.gcube.vremanagement.resourcemanager.impl.state.PublishedScopeResource;
import org.gcube.vremanagement.resourcemanager.impl.state.ScopeState;
import org.gcube.vremanagement.resourcemanager.impl.state.ScopeStateList;
import org.gcube.vremanagement.resourcemanager.impl.state.VirtualNode;
import org.gcube.vremanagement.resourcemanager.impl.state.observers.Disposer;
import org.gcube.vremanagement.resourcemanager.impl.state.observers.Executor;
import org.gcube.vremanagement.resourcemanager.impl.state.observers.Publisher;
import org.gcube.vremanagement.resourcemanager.impl.state.observers.Serializer;
import org.globus.wsrf.NoSuchResourceException;

public final class InstanceState
extends GCUBEWSResource {
    static final ScopeStateList resources = new ScopeStateList();
    static Map<String, Session> id2session = Collections.synchronizedMap(new HashMap());

    protected void initialise(Object ... params) throws Exception {
        this.reuseState(this.getScope());
    }

    protected void reuseState(GCUBEScope scope) throws Exception {
        resources.initializeScope(scope);
        final ScopeState state = resources.getState(scope);
        this.registerObservers(state);
        new Thread("ReuseStateThread" + scope.getName()){

            @Override
            public void run() {
                state.notifyObservers();
            }
        }.start();
    }

    public Session getSession(String id) throws IOException {
        if (!id2session.containsKey(id)) {
            id2session.put(id, Session.load(id));
        }
        return id2session.get(id);
    }

    public String getSerializedSession(String id) throws IOException {
        return Session.loadAsString(id);
    }

    public void addSession(GCUBEScope scope, Session session) throws NoSuchResourceException {
        this.getState(scope).setLastSession(session);
        id2session.put(session.getId(), session);
    }

    public ScopeState getState(GCUBEScope scope) throws NoSuchResourceException {
        ScopeState state = resources.getState(scope);
        if (state == null) {
            throw new NoSuchResourceException();
        }
        return state;
    }

    public void disposeState(GCUBEScope scope, Session report) throws IOException, VirtualNode.NoGHNFoundException {
        ScopeState scopeState = resources.getState(scope);
        if (scopeState == null) {
            this.logger.warn((Object)("a scope state does not exist for " + scope));
            return;
        }
        HashSet<ScopedResource> allResources = new HashSet<ScopedResource>();
        for (ScopedResource resource : scopeState.getAllResources()) {
            if (resource.getType().compareTo("Service") == 0 || resource.getStatus() == ScopedResource.STATUS.UNPUBLISHED || resource.getStatus() == ScopedResource.STATUS.LOST || resource.getStatus() == ScopedResource.STATUS.REMOVED) continue;
            allResources.add(resource);
            report.addResource(resource);
        }
        scopeState.removeResources(allResources);
        report.save();
        scopeState.markAsDisposed();
        resources.removeState(scopeState);
    }

    public PublishedScopeResource getPublishedScopeResource(GCUBEScope scope) throws NoSuchResourceException {
        return resources.getPublishedScopeResource(scope);
    }

    public void createState(GCUBEScope scope) throws NoSuchResourceException, Exception {
        ScopeState state = resources.createState(scope);
        this.registerObservers(state);
        state.notifyObservers();
    }

    private void registerObservers(ScopeState state) {
        state.addObserver(new Executor());
        state.addObserver(new Publisher());
        state.addObserver(new Serializer());
        state.addObserver(new Disposer());
    }
}

