/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcebroker.utils.serialization.types.feedback;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.List;
import java.util.Vector;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.PlanBuilderIdentifier;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.feedback.DeployNode;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.feedback.FeedbackStatus;

public class Feedback {
    public static final String NODE_TAG = "Feedback";
    @XStreamAsAttribute
    private String planID = null;
    @XStreamAlias(value="Scope")
    private String scope = null;
    private List<DeployNode> deployNodes = new Vector<DeployNode>();

    public Feedback() {
        this.planID = new BigInteger(130, new SecureRandom()).toString(32);
    }

    public Feedback(PlanBuilderIdentifier workflowSession, String scope) {
        this.planID = workflowSession.getID();
        this.scope = scope;
    }

    public final String getPlanID() {
        return this.planID;
    }

    public final void setPlanID(String planID) {
        this.planID = planID;
    }

    public final int getScore() {
        if (this.getDeployNodes() == null || this.getDeployNodes().size() == 0) {
            return Math.round(FeedbackStatus.SUCCESS.getWeight());
        }
        float partial = 0.0f;
        for (DeployNode dn : this.getDeployNodes()) {
            partial += (float)dn.getScore();
        }
        float percentage = partial / (float)this.getDeployNodes().size();
        return Math.round(percentage);
    }

    public final List<DeployNode> getDeployNodes() {
        return this.deployNodes;
    }

    public final void addDeployNode(DeployNode deployNode) {
        this.deployNodes.add(deployNode);
    }

    public final String getScope() {
        return this.scope;
    }

    public final void setScope(String scope) {
        this.scope = scope;
    }
}

