/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcebroker.utils.serialization.types.requirements;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.requirements.RequirementElemPath;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.requirements.RequirementElemType;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.requirements.RequirementRelationType;

@XStreamAlias(value="Requirement")
public class Requirement {
    public static final String NODE_TAG = "Requirement";
    @XStreamAlias(value="node")
    private RequirementElemPath elem = null;
    @XStreamAlias(value="key")
    private String key = null;
    private RequirementRelationType relType = null;
    @XStreamAlias(value="value")
    private String value = null;

    public Requirement(RequirementElemPath elem, RequirementRelationType relType, String value) {
        this.elem = elem;
        this.value = value;
        this.relType = relType;
    }

    public Requirement(RequirementElemPath elem, String value) {
        this.elem = elem;
        this.value = value;
    }

    public Requirement(RequirementElemPath elem, String key, RequirementRelationType relType, String value) {
        this(elem, relType, value);
        this.key = key;
    }

    public RequirementElemPath getElem() {
        return this.elem;
    }

    public String getValue() {
        return this.value;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public RequirementRelationType getRelType() {
        return this.relType;
    }

    public String getEvalString() {
        String query = this.elem.getPath();
        if (this.getElem() == RequirementElemPath.RUNTIME_ENV_STRING || this.getElem() == RequirementElemPath.RUNTIME_ENV_NUMBER) {
            if (this.key == null) {
                return null;
            }
            query = query.replace("$1", "Key = '" + this.key + "'");
            query = this.value != null ? (this.getRelType() != RequirementRelationType.CONTAINS ? query.replace("$2", "and Value " + this.getRelType().getRelType() + " " + this.getFormattedValue()) : query.replace("$2", "and Value [contains (., " + this.getFormattedValue() + ")]")) : query.replace("$2", "");
            return query;
        }
        if (this.getElem() == RequirementElemPath.CUSTOM_REQUIREMENT) {
            if (this.getValue() == null) {
                return null;
            }
            query = query.replace("$1", this.getValue());
            return query;
        }
        if (this.getRelType() != RequirementRelationType.CONTAINS) {
            query = query.replace("$1", this.getRelType().getRelType());
            query = query.replace("$2", this.getFormattedValue());
        } else {
            query = !query.contains("[") ? query.replace("$1", "[contains(., " + this.getFormattedValue() + ")]") : query.replace("$1", "contains(.," + this.getFormattedValue() + ")");
            query = query.replace("$2", "");
        }
        return query;
    }

    private final String getFormattedValue() {
        if (this.value != null) {
            return (this.getElem().getValueType() == RequirementElemType.STRING ? "'" : "") + this.value.trim() + (this.getElem().getValueType() == RequirementElemType.STRING ? "'" : "");
        }
        return null;
    }

    public final int hashCode() {
        return this.getEvalString().hashCode();
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof Requirement)) {
            return false;
        }
        Requirement param = (Requirement)obj;
        return this.getEvalString().compareTo(param.getEvalString()) == 0;
    }
}

