/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcebroker.impl.planbuilders.generictasks;

import java.util.List;
import java.util.Vector;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.vremanagement.resourcebroker.impl.planbuilders.PlanBuilderElem;
import org.gcube.vremanagement.resourcebroker.impl.planbuilders.PlanBuilderException;
import org.gcube.vremanagement.resourcebroker.impl.planbuilders.PlanBuilderTask;
import org.gcube.vremanagement.resourcebroker.impl.planbuilders.PlanExceptionMessages;
import org.gcube.vremanagement.resourcebroker.impl.services.ISRequirementsRequester;
import org.gcube.vremanagement.resourcebroker.utils.assertions.Assertion;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.PackageElem;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.PackageGroup;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.requirements.Requirement;

public class AddRequirements
extends PlanBuilderTask {
    @Override
    public final PlanBuilderElem makeDecision(PlanBuilderElem input) throws PlanBuilderException {
        this.logger.debug((Object)"Adding requirements");
        Assertion<PlanBuilderException> checker = new Assertion<PlanBuilderException>();
        checker.validate(input != null, new PlanBuilderException(PlanExceptionMessages.INVALID_REQUEST));
        checker.validate(input.getRequest() != null, new PlanBuilderException(PlanExceptionMessages.INVALID_REQUEST));
        checker.validate(input.getRequest().getScope() != null, new PlanBuilderException(PlanExceptionMessages.INVALID_REQUEST_SCOPE));
        GCUBEScope scope = GCUBEScope.getScope((String)input.getRequest().getScope());
        for (PackageGroup pg : input.getRequest().getPackageGroups()) {
            Vector<Requirement> reqs = new Vector<Requirement>();
            for (PackageElem pkg : pg.getPackages()) {
                this.logger.info((Object)("Getting requirements for package " + pkg.getServiceName() + "/" + pkg.getServiceClass() + "/" + pkg.getPackageName()));
                try {
                    List<Requirement> toadd = ISRequirementsRequester.getRequirements(scope, pkg);
                    if (toadd == null) continue;
                    reqs.addAll(toadd);
                }
                catch (Exception e) {
                    this.logger.error((Object)e);
                }
            }
            if (reqs.isEmpty()) continue;
            pg.addRequirements(reqs.toArray(new Requirement[0]));
        }
        return input;
    }
}

