/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcebroker.local.testsuite;

import java.util.List;
import java.util.Properties;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.QueryParameter;
import org.gcube.common.core.informationsystem.client.XMLResult;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericQuery;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.vremanagement.resourcebroker.impl.support.queries.QueryLoader;
import org.gcube.vremanagement.resourcebroker.impl.support.queries.QueryPath;
import org.gcube.vremanagement.resourcebroker.local.testsuite.StandaloneISQueryTest;
import org.gcube.vremanagement.resourcebroker.utils.performance.PerformanceMonitor;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.requirements.Requirement;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.requirements.RequirementElemPath;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.requirements.RequirementRelationType;

public class RequirementTest {
    private PerformanceMonitor timer = new PerformanceMonitor();
    private GCUBEClientLog logger = new GCUBEClientLog(StandaloneISQueryTest.class, new Properties[0]);

    private void testMatching(XMLResult node, Requirement[] reqs) {
        for (Requirement req : reqs) {
            try {
                List results = node.evaluate(req.getEvalString());
                if (results != null && results.size() > 0) {
                    String result = (String)results.get(0);
                    this.logger.debug((Object)("*** [OK] value of node " + req.getEvalString() + ": " + result));
                    continue;
                }
                this.logger.error((Object)("*** [FAIL] cannot find results for: " + req.getEvalString()));
            }
            catch (XMLResult.ISResultEvaluationException e) {
                this.logger.error((Object)("*** cannot find results for: " + req.getEvalString()));
                e.printStackTrace();
            }
        }
    }

    public void doJob(String query, Requirement[] reqs) {
        this.timer.start();
        this.logger.debug((Object)"*** ISClientRequester accessing the IS");
        List results = null;
        try {
            ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
            GCUBEGenericQuery isQuery = null;
            isQuery = (GCUBEGenericQuery)client.getQuery(GCUBEGenericQuery.class);
            isQuery.setExpression(query);
            isQuery.addParameters(new QueryParameter[]{new AtomicCondition("MAXWAIT", "40")});
            results = client.execute((ISQuery)isQuery, GCUBEScope.getScope((String)"/gcube/devsec"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.logger.debug((Object)"*********************************************************************************");
        this.logger.debug((Object)("QUERY: \n" + query));
        this.logger.debug((Object)"*********************************************************************************");
        if (results == null || results.isEmpty()) {
            this.logger.debug((Object)"NO RESULTS!!! \n\n");
        } else {
            XMLResult node = (XMLResult)results.get(0);
            this.logger.debug((Object)(node + "\n\n"));
            this.testMatching(node, reqs);
        }
        this.timer.stop();
        this.logger.debug((Object)("Elapsed time: [" + this.timer.getLastIntervalSecs() + "s]"));
    }

    public static void main(String[] args) throws Exception {
        String query = QueryLoader.getQuery(QueryPath.COUNT_RI_ON_DYNAMIC_ALIVE_GHN);
        Requirement[] reqs = new Requirement[]{new Requirement(RequirementElemPath.OS, RequirementRelationType.NOT_EQUAL, "OSX"), new Requirement(RequirementElemPath.PLATFORM, RequirementRelationType.EQUAL, "i386"), new Requirement(RequirementElemPath.MEM_RAM_AVAILABLE, RequirementRelationType.GREATER_OR_EQUAL, "200"), new Requirement(RequirementElemPath.MEM_RAM_SIZE, RequirementRelationType.GREATER, "3000"), new Requirement(RequirementElemPath.MEM_VIRTUAL_AVAILABLE, RequirementRelationType.GREATER, "280"), new Requirement(RequirementElemPath.MEM_VIRTUAL_SIZE, RequirementRelationType.GREATER, "300"), new Requirement(RequirementElemPath.HOST, RequirementRelationType.CONTAINS, "aurora"), new Requirement(RequirementElemPath.DISK_SPACE, RequirementRelationType.GREATER, "800"), new Requirement(RequirementElemPath.LOAD1MIN, RequirementRelationType.LESS, "1"), new Requirement(RequirementElemPath.LOAD5MIN, RequirementRelationType.LESS, "1"), new Requirement(RequirementElemPath.LOAD15MIN, RequirementRelationType.LESS, "0.02"), new Requirement(RequirementElemPath.PROCESSOR_NUM, RequirementRelationType.NOT_EQUAL, "2"), new Requirement(RequirementElemPath.PROCESSOR_NUM, RequirementRelationType.EQUAL, "2"), new Requirement(RequirementElemPath.PROCESSOR_BOGOMIPS, RequirementRelationType.GREATER_OR_EQUAL, "3000"), new Requirement(RequirementElemPath.SITE_LOCATION, RequirementRelationType.CONTAINS, "Athens"), new Requirement(RequirementElemPath.SITE_COUNTRY, RequirementRelationType.CONTAINS, "it"), new Requirement(RequirementElemPath.SITE_DOMAIN, RequirementRelationType.CONTAINS, "research-infrastructures.eu"), new Requirement(RequirementElemPath.RUNTIME_ENV_STRING, "ANT_HOME", RequirementRelationType.CONTAINS, "/ant"), new Requirement(RequirementElemPath.RUNTIME_ENV_STRING, "ANT_HOME", RequirementRelationType.EQUAL, "/usr/share/ant"), new Requirement(RequirementElemPath.RUNTIME_ENV_STRING, "GLOBUS_OPTIONS", RequirementRelationType.EQUAL, null), new Requirement(RequirementElemPath.CUSTOM_REQUIREMENT, "/GHNDescription/Architecture[@PlatformType = 'i386']")};
        new RequirementTest().doJob(query, reqs);
    }
}

