/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcebroker.impl.support.threads;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcebroker.impl.configuration.BrokerConfiguration;

public abstract class TimedThread
extends Thread {
    private long loopDelay = 0L;
    private boolean isStopped = false;
    private boolean startAtInstantiation = true;
    protected GCUBELog logger = new GCUBELog((Object)this, BrokerConfiguration.getProperty("LOGGING_PREFIX"));

    protected TimedThread(long millsSlot) {
        this(millsSlot, false);
    }

    protected TimedThread(long millsSlot, boolean startAtInstantiation) {
        this.loopDelay = millsSlot;
        this.startAtInstantiation = startAtInstantiation;
        this.logger.info((Object)("[TT-CREATION] Created a TimedThread " + this.getClass().getSimpleName() + " having delay [" + millsSlot / 1000L + "]s starting at instantiation: " + this.startAtInstantiation));
    }

    public abstract void loop();

    @Override
    public final synchronized void run() {
        if (this.startAtInstantiation) {
            this.loop();
        }
        while (!this.isStopped) {
            try {
                this.wait(this.loopDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.loop();
        }
        super.interrupt();
    }

    @Override
    public final synchronized void interrupt() {
        this.logger.debug((Object)"[STOP] Interrupting");
        this.isStopped = true;
        this.notify();
    }
}

