/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcebroker.impl.planbuilders.generictasks;

import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.vremanagement.resourcebroker.impl.planbuilders.PlanBuilderElem;
import org.gcube.vremanagement.resourcebroker.impl.planbuilders.PlanBuilderException;
import org.gcube.vremanagement.resourcebroker.impl.planbuilders.PlanBuilderTask;
import org.gcube.vremanagement.resourcebroker.impl.planbuilders.PlanExceptionMessages;
import org.gcube.vremanagement.resourcebroker.impl.services.GHNReservationHandler;
import org.gcube.vremanagement.resourcebroker.impl.support.types.GHNDescriptor;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.GHNList;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.PackageElem;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.PackageGroup;

public class SuggestedGHNTask
extends PlanBuilderTask {
    @Override
    public final PlanBuilderElem makeDecision(PlanBuilderElem input) throws PlanBuilderException {
        GHNList suggestedGHNs = input.getRequest().getGHNList();
        GCUBEScope queryScope = GCUBEScope.getScope((String)input.getRequest().getScope());
        if (suggestedGHNs == null || suggestedGHNs.getGHNs() == null || suggestedGHNs.getGHNs().size() == 0 || input.getRequest() == null || input.getRequest().getPackageGroups() == null || input.getRequest().getPackageGroups().size() == 0) {
            return input;
        }
        Vector<GHNDescriptor> ghnsToUse = null;
        GHNReservationHandler resHandler = GHNReservationHandler.getInstance();
        try {
            resHandler.getReservedGHNs(queryScope, this.identifier);
        }
        catch (GCUBEFault e1) {
            return input;
        }
        if (ghnsToUse == null) {
            ghnsToUse = new Vector<GHNDescriptor>();
        }
        for (String ghnID : suggestedGHNs.getGHNs()) {
            GHNDescriptor ghn = null;
            try {
                ghn = resHandler.getGHNByID(this.identifier, GCUBEScope.getScope((String)input.getRequest().getScope()), ghnID);
                if (ghn == null) {
                    throw new PlanBuilderException(PlanExceptionMessages.INVALID_GHNS, "Suggested GHN: " + ghnID);
                }
                ghnsToUse.add(ghn);
            }
            catch (GCUBEFault e) {
                throw new PlanBuilderException(PlanExceptionMessages.INVALID_GHNS, "Suggested GHN: " + ghnID);
            }
        }
        List pckgroupsToAssign = input.getRequest().getPackageGroups();
        Vector<PackageGroup> pkggroupsToRemove = new Vector<PackageGroup>();
        for (PackageGroup pgToAssign : pckgroupsToAssign) {
            Collections.sort(ghnsToUse);
            PackageGroup pckGrp = input.getResponse().createPackageGroup(pgToAssign.getServiceName());
            try {
                resHandler.reserveGHN(this.identifier, (GHNDescriptor)ghnsToUse.get(0));
            }
            catch (GCUBEFault e) {
                ((GHNDescriptor)ghnsToUse.get(0)).increaseRICount();
            }
            pckGrp.setGHN((String)((GHNDescriptor)ghnsToUse.get(0)).getElement());
            for (PackageElem pkg : pgToAssign.getPackages()) {
                pckGrp.addPackage(pkg);
                pckGrp.setID(pgToAssign.getID());
            }
            pkggroupsToRemove.add(pgToAssign);
        }
        for (PackageGroup toremove : pkggroupsToRemove) {
            input.getRequest().getPackageGroups().remove(toremove);
        }
        return input;
    }
}

