/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcebroker.impl.support.threads;

import java.util.List;
import java.util.Vector;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcebroker.impl.configuration.BrokerConfiguration;
import org.gcube.vremanagement.resourcebroker.impl.contexts.ServiceInitializer;
import org.gcube.vremanagement.resourcebroker.impl.support.threads.TimedThread;

public class TimedThreadsStorage {
    private static GCUBELog logger = new GCUBELog(ServiceInitializer.class, BrokerConfiguration.getProperty("LOGGING_PREFIX") + "::[TT-STORAGE]");
    private static final List<TimedThread> THREADS = new Vector<TimedThread>();

    public static synchronized void stopAll() {
        for (TimedThread t : THREADS) {
            t.interrupt();
        }
    }

    public static synchronized void registerThread(TimedThread thread) {
        TimedThreadsStorage.registerThread(thread, false);
    }

    public static synchronized void registerThread(TimedThread thread, boolean toStart) {
        logger.debug((Object)("[TT-REGISTER] Enabling TimedThread: " + thread.getClass().getSimpleName()));
        THREADS.add(thread);
        if (toStart) {
            thread.start();
        }
    }
}

