/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcebroker.impl.configuration;

import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Properties;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcebroker.impl.configuration.Configuration;

public final class BrokerConfiguration {
    private GCUBELog logger = new GCUBELog((Object)this, "BMM");
    private static BrokerConfiguration singleton = new BrokerConfiguration("etc/org.gcube.vremanagement.resourcebroker/broker.properties");
    private Properties properties = null;

    private BrokerConfiguration(String confFile) {
        if (this.properties == null) {
            this.properties = this.load(confFile);
        }
    }

    public static void setConfigurationFile(String filename) {
        BrokerConfiguration.singleton.properties = singleton.load(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties load(String propsName) {
        this.logger.debug((Object)"[CONF] loading configuration");
        Properties props = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(propsName);
            props.load(fis);
        }
        catch (Exception e) {
            this.logger.warn((Object)"[CONF] cannot find configuration file. Trying in standalone mode.");
            try {
                fis = new FileInputStream("etc/broker.properties");
                props.load(fis);
            }
            catch (Exception e1) {
                this.logger.warn((Object)"[CONF] cannot find local standalone configuration file");
            }
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return props;
    }

    protected static BrokerConfiguration getInstance() {
        return singleton;
    }

    public static Properties getProperties() {
        return BrokerConfiguration.getInstance().properties;
    }

    public static String getProperty(String key) throws RuntimeException {
        try {
            Class<?> c = Class.forName(Configuration.class.getName());
            Field field = c.getField(key);
            String defaultValue = field.get(null).toString();
            return BrokerConfiguration.getInstance().properties.getProperty(key, defaultValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static int getIntProperty(String key) throws RuntimeException {
        return Integer.parseInt(BrokerConfiguration.getProperty(key));
    }

    public static boolean getBoolProperty(String key) throws RuntimeException {
        return Boolean.parseBoolean(BrokerConfiguration.getProperty(key));
    }

    public static Object getRawProperty(String key) throws RuntimeException {
        try {
            Class<?> c = Class.forName(Configuration.class.getName());
            Field field = c.getField(key);
            Object defaultValue = field.get(null);
            if (!BrokerConfiguration.getInstance().properties.containsKey(key)) {
                return defaultValue;
            }
            return BrokerConfiguration.getInstance().properties.get(key);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

