/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcebroker.impl.planbuilders;

import java.util.List;
import java.util.Vector;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcebroker.impl.configuration.BrokerConfiguration;
import org.gcube.vremanagement.resourcebroker.impl.planbuilders.PlanBuilderElem;
import org.gcube.vremanagement.resourcebroker.impl.planbuilders.PlanBuilderException;
import org.gcube.vremanagement.resourcebroker.impl.planbuilders.PlanBuilderTask;
import org.gcube.vremanagement.resourcebroker.utils.serialization.parser.xstream.XStreamTransformer;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.PlanRequest;

public class PlanBuilderWorkflow {
    private GCUBELog logger = new GCUBELog((Object)this, BrokerConfiguration.getProperty("LOGGING_PREFIX"));
    private List<PlanBuilderTask> tasks = new Vector<PlanBuilderTask>();
    private PlanBuilderElem partialResult = null;
    private PlanRequest initialRequest = null;

    public PlanBuilderWorkflow(PlanBuilderElem input) {
        this.partialResult = input;
        try {
            XStreamTransformer transformer = new XStreamTransformer();
            String reqXML = transformer.toXML(input.getRequest());
            this.initialRequest = transformer.getRequestFromXML(reqXML, false);
            this.logger.debug((Object)"[PLAN-WF] cloning the initial PlanRequest [DONE]");
        }
        catch (GCUBEFault e) {
            this.logger.debug((Object)"[PLAN-WF] cloning the initial PlanRequest [ERR]");
            this.logger.error((Object)e);
        }
    }

    public final void addPlanBuilderTask(PlanBuilderTask task) {
        this.tasks.add(task);
        task.setID(this.partialResult.getID());
    }

    public final PlanBuilderElem run() throws PlanBuilderException {
        for (PlanBuilderTask task : this.tasks) {
            this.partialResult = task.makeDecision(this.partialResult);
        }
        return this.partialResult;
    }

    public final PlanBuilderElem getPartialResult() {
        return this.partialResult;
    }

    public final PlanRequest getInitialRequest() {
        return this.initialRequest;
    }
}

