/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.softwaregateway.impl.porttypes;

import java.io.File;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.softwaregateway.webserver.WebServer;

public class ServiceContext
extends GCUBEServiceContext {
    public static final String JNDI_NAME = "gcube/vremanagement/softwaregateway";
    private static final ServiceContext singleton = new ServiceContext();
    private final GCUBELog logger = new GCUBELog(ServiceContext.class);
    private String dbFileName;
    private String username;
    private String password;
    private File queriesFile;
    private File tmp;
    private File pending;
    private File maven;
    private String mavenSettingsFileName;
    private File httpServerBasePath;
    private int httpServerPort;
    private String httpBaseUrl;
    private String mavenRelativeDir;
    private String reportRelativeDir;
    private File xsltDir;
    private String indexXSLTfilename;
    private String indexCSSfilename;
    private String reportXSLTfilename;
    private String relativeJavadocPath;
    private String sourceCodeLinkPathfilename;
    private String bannedArtifactVersion;
    private String[] xPathsVersionCheck;
    private String acceptedDependencyVersion;
    private WebServer server = null;

    private ServiceContext() {
    }

    public static ServiceContext getContext() {
        return singleton;
    }

    public String getJNDIName() {
        return JNDI_NAME;
    }

    protected void onInitialisation() {
        this.logger.debug((Object)"in initialization");
        this.logger.debug((Object)("banned version: " + this.bannedArtifactVersion));
        this.username = (String)this.getProperty("username", new boolean[]{true});
        this.password = (String)this.getProperty("password", new boolean[]{true});
        String dbDir = "dbFolder";
        File dbDirFileName = this.getPersistentFile(dbDir, new boolean[]{false});
        if (!dbDirFileName.exists()) {
            dbDirFileName.mkdirs();
        }
        this.tmp = this.getPersistentFile((String)this.getProperty("tmpDir", new boolean[]{true}), new boolean[]{false});
        if (!this.tmp.exists()) {
            this.tmp.mkdirs();
        }
        this.logger.debug((Object)("Tmp directory = " + this.tmp.getAbsolutePath()));
        this.pending = this.getPersistentFile((String)this.getProperty("pendingDir", new boolean[]{true}), new boolean[]{false});
        if (!this.pending.exists()) {
            this.pending.mkdirs();
        }
        this.logger.debug((Object)("Pending directory = " + this.pending.getAbsolutePath()));
        this.maven = this.getPersistentFile((String)this.getProperty("mavenDir", new boolean[]{true}), new boolean[]{false});
        if (!this.maven.exists()) {
            this.maven.mkdir();
        }
        this.logger.debug((Object)("Maven directory = " + this.maven.getAbsolutePath()));
        this.mavenSettingsFileName = (String)this.getProperty("mavenSettingsFileName", new boolean[]{true});
        this.logger.debug((Object)("Maven settings file path = " + this.mavenSettingsFileName));
        this.httpServerBasePath = this.getPersistentFile((String)this.getProperty("httpServerBasePath", new boolean[]{true}), new boolean[]{false});
        this.logger.debug((Object)("HTTP Server Base path = " + this.httpServerBasePath.getAbsolutePath()));
        if (!this.httpServerBasePath.exists()) {
            this.httpServerBasePath.mkdirs();
        }
        this.httpServerPort = Integer.parseInt((String)this.getProperty("httpServerPort", new boolean[]{true}));
        this.logger.debug((Object)("HTTP Server port = " + this.httpServerPort));
        this.logger.debug((Object)("CHECK: httpServerBasePath=" + this.httpServerBasePath + " httpServerPort" + this.httpServerPort));
        this.logger.debug((Object)("CHECK: httpServerBasePath=" + this.httpServerBasePath + " httpServerPort" + this.httpServerPort));
        this.mavenRelativeDir = (String)this.getProperty("mavenRelativeDir", new boolean[]{true});
        this.logger.debug((Object)("HTTP relative Maven directory = " + this.mavenRelativeDir));
        File mavenDir = new File(this.httpServerBasePath.getAbsolutePath(), this.mavenRelativeDir);
        if (!mavenDir.exists()) {
            mavenDir.mkdirs();
        }
        this.reportRelativeDir = (String)this.getProperty("reportRelativeDir", new boolean[]{true});
        this.logger.debug((Object)("HTTP relative Report directory = " + this.reportRelativeDir));
        File reportDirectory = new File(this.httpServerBasePath.getAbsolutePath(), this.reportRelativeDir);
        if (!reportDirectory.exists()) {
            reportDirectory.mkdirs();
        }
        this.xsltDir = this.getFile((String)this.getProperty("xsltDir", new boolean[]{true}), new boolean[]{false});
        this.logger.debug((Object)("XSLT directory = " + this.xsltDir));
        try {
            String webServerClass = (String)this.getProperty("webServerClass", new boolean[]{true});
            this.logger.debug((Object)("webServerClass: " + webServerClass));
            Thread.currentThread().getContextClassLoader().getClass();
            Class<?> cls = Class.forName(webServerClass);
        }
        catch (Exception e) {
            this.logger.fatal((Object)"Unable to Start Web Server", (Throwable)e);
            return;
        }
    }

    public File getHttpServerBasePath() {
        return this.httpServerBasePath;
    }

    public int getHttpServerPort() {
        return this.httpServerPort;
    }

    public String getBaseUrl() {
        return this.httpBaseUrl;
    }

    public String getMavenRelativeDir() {
        return this.mavenRelativeDir;
    }

    public File getTmp() {
        return this.tmp;
    }

    public String getMavenSettingsFileName() {
        return this.mavenSettingsFileName;
    }

    public String getReportRelativeDir() {
        return this.reportRelativeDir;
    }
}

