/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.softwaregateway.impl.repositorymanager.parsing;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.softwaregateway.impl.coordinates.Coordinates;
import org.gcube.vremanagement.softwaregateway.impl.coordinates.GCubeCoordinates;
import org.gcube.vremanagement.softwaregateway.impl.exceptions.ServiceNotAvaiableFault;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.util.FileUtilsExtended;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlParse {
    private GCUBELog logger = new GCUBELog(XmlParse.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getURlFromSearch(String xml, String groupName, String artifact, String extension, String ver, boolean pom, String classifier) throws IOException, SAXException {
        String url;
        block13: {
            url = null;
            this.logger.debug((Object)"getUrlFromSearch method");
            this.logger.debug((Object)("search: " + groupName + " " + artifact + " " + ver + " with ext: " + extension + " and classifier " + classifier));
            this.logger.debug((Object)"extract root element from xml");
            Element root = this.extractRootElement(xml.getBytes());
            this.logger.debug((Object)("root element extracted: " + root));
            try {
                List<Node> dataNode = this.extractChild(root, "data");
                List<Node> artifactList = this.extractChild(dataNode.get(0), "artifact");
                if (artifactList == null || artifactList.size() <= 0) break block13;
                this.logger.debug((Object)("artifact founded: " + artifactList.size()));
                for (int i = 0; i < artifactList.size(); ++i) {
                    Node child = artifactList.get(i);
                    List<Node> id = this.extractChild(child, "artifactId");
                    String artifactId = id.get(0).getTextContent();
                    this.logger.debug((Object)("artifactId: " + artifactId));
                    if (!artifactId.equalsIgnoreCase(artifact)) continue;
                    List<Node> extensionList = this.extractChild(child, "extension");
                    String ext = extensionList.get(0).getTextContent();
                    this.logger.debug((Object)("extension founded " + ext));
                    if (extension != null && (!ext.equalsIgnoreCase("pom") || !pom) && !ext.equalsIgnoreCase(extension) && !ext.equalsIgnoreCase("war") && !ext.equalsIgnoreCase("jar") && !ext.equalsIgnoreCase("gar") && classifier == null) continue;
                    if (ver != null) {
                        List<Node> versionList = this.extractChild(child, "version");
                        String version = versionList.get(0).getTextContent();
                        this.logger.debug((Object)("version founded: " + version));
                        if (!ver.contains(version)) continue;
                        if (pom) {
                            List<Node> pomList = this.extractChild(child, "pomLink");
                            url = pomList.get(0).getTextContent();
                            this.logger.debug((Object)("pom link founded 1: " + url));
                            if (url == null || url.isEmpty()) continue;
                            break;
                        }
                        List<Node> classifierList = this.extractChild(child, "classifier");
                        if (classifierList != null) {
                            List<Node> uriList;
                            String classifierFounded = classifierList.get(0).getTextContent();
                            this.logger.debug((Object)("classifier founded: " + classifierFounded + " classifier searched: " + classifier));
                            if (classifierFounded == null && classifier == null) {
                                uriList = this.extractChild(child, "artifactLink");
                                url = uriList.get(0).getTextContent();
                                if (extension == null) continue;
                                break;
                            }
                            if (classifierFounded != null && classifier != null && classifier.equalsIgnoreCase(classifierFounded)) {
                                uriList = this.extractChild(child, "artifactLink");
                                url = uriList.get(0).getTextContent();
                                break;
                            } else {
                                if (!classifierFounded.equalsIgnoreCase("servicearchive") || classifier != null) continue;
                                uriList = this.extractChild(child, "artifactLink");
                                url = uriList.get(0).getTextContent();
                                continue;
                            }
                        }
                        this.logger.debug((Object)("classifier not  founded. classifier searched is " + classifier));
                        if (classifier != null && (!classifier.equalsIgnoreCase("servicearchive") || !extension.equalsIgnoreCase("jar"))) continue;
                        List<Node> uriList = this.extractChild(child, "artifactLink");
                        url = uriList.get(0).getTextContent();
                        if (extension == null) continue;
                        break;
                    }
                    this.logger.debug((Object)"version founded is null ");
                    if (pom) {
                        List<Node> pomList = this.extractChild(child, "pomLink");
                        url = pomList.get(0).getTextContent();
                        this.logger.debug((Object)("pom link founded 1: " + url));
                        if (url != null && !url.isEmpty()) {
                            break;
                        }
                    } else {
                        List<Node> uriList = this.extractChild(child, "artifactLink");
                        url = uriList.get(0).getTextContent();
                    }
                    if (extension == null) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.logger.debug((Object)(" url founded: " + url));
        return url;
    }

    private Element extractRootElement(byte[] xml) {
        this.logger.debug((Object)" extractRoot method ");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        Document domDocument = null;
        try {
            builder = factory.newDocumentBuilder();
            domDocument = builder.parse(new ByteArrayInputStream(xml));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Element root = domDocument.getDocumentElement();
        return root;
    }

    private List<Node> extractChild(Node node, String name) {
        this.logger.debug((Object)(" extractChild method: " + name));
        ArrayList<Node> result = null;
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node child = nodeList.item(i);
                String tag = child.getNodeName();
                this.logger.debug((Object)(" founded tag: " + tag));
                if (!tag.equalsIgnoreCase(name)) continue;
                if (result == null) {
                    result = new ArrayList<Node>();
                }
                result.add(child);
            }
        } else {
            this.logger.debug((Object)"no packages founded ");
        }
        return result;
    }

    public File updateProfile(File profile, Coordinates coordinates) throws ServiceNotAvaiableFault {
        block5: {
            this.logger.debug((Object)"updateProfile method");
            boolean found = false;
            try {
                String packageName = coordinates.getPackageName();
                String packageVersion = coordinates.getPackageVersion();
                String profileString = FileUtilsExtended.fileToString(profile.getAbsolutePath());
                this.logger.debug((Object)("update profile  " + profileString));
                Element root = this.extractRootElement(profileString.getBytes());
                List<Node> nodes = this.extractChild(root, "Profile");
                if (nodes != null && nodes.size() == 1) {
                    List<Node> packages = this.extractChild(nodes.get(0), "Packages");
                    if (packages == null) {
                        throw new ServiceNotAvaiableFault(" no packages founded in profile ");
                    }
                    for (Node node : packages) {
                        List<Node> childs = this.extractChild(node, "Software");
                        this.updateCoordinates(node, childs, coordinates);
                        if (!found) continue;
                    }
                    break block5;
                }
                this.logger.error((Object)"incorrect profile, ");
                throw new ServiceNotAvaiableFault();
            }
            catch (Exception e) {
                throw new ServiceNotAvaiableFault();
            }
        }
        return profile;
    }

    public File updateFile(File file, GCubeCoordinates coord) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        Document document = null;
        File profile = file;
        try {
            builder = factory.newDocumentBuilder();
            document = builder.parse(profile);
            this.filterElements(document, coord);
            String result = this.xmlToString(document);
            FileUtilsExtended.stringToFile(result, profile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return profile;
    }

    public void filterElements(Node parent, GCubeCoordinates coord) {
        NodeList children = parent.getChildNodes();
        String version = "";
        String groupId = "";
        String artifactId = "";
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            this.logger.debug((Object)("parse: " + child.getNodeName() + " node"));
            if (child.getNodeType() != 1) continue;
            if (child.getNodeName().equals("Coordinate")) {
                NodeList coordinateNodes = child.getChildNodes();
                String name = "";
                String value = "";
                for (int j = 0; j < coordinateNodes.getLength(); ++j) {
                    Node node = coordinateNodes.item(j);
                    this.logger.debug((Object)("Coordinate. name: " + node.getNodeName() + " value: " + node.getTextContent()));
                    if (node.getNodeName().equalsIgnoreCase("name")) {
                        name = node.getTextContent();
                        continue;
                    }
                    if (!node.getNodeName().equalsIgnoreCase("Value")) continue;
                    value = node.getTextContent();
                }
                if (name.equalsIgnoreCase("groupid")) {
                    groupId = value;
                } else if (name.equalsIgnoreCase("artifactId")) {
                    artifactId = value;
                } else if (name.equalsIgnoreCase("version")) {
                    version = value;
                }
                this.logger.debug((Object)("gid: " + groupId + " aid: " + artifactId + " v: " + version));
                this.logger.debug((Object)("PACKAGE NAME: " + coord.getPackageName() + " version " + coord.getPackageVersion()));
                if (groupId.isEmpty() || artifactId.isEmpty() || version.isEmpty()) continue;
                if (coord.getPackageName().equalsIgnoreCase(artifactId) && coord.getPackageVersion().equalsIgnoreCase(version)) {
                    this.logger.debug((Object)"PACKAGE FOUND");
                    continue;
                }
                Node granParent = parent.getParentNode();
                Node ancient = granParent.getParentNode();
                this.logger.debug((Object)("ANCIENT IS: " + ancient.getNodeName()));
                this.logger.debug((Object)("GRAN PARENT IS: " + granParent.getNodeName()));
                ancient.removeChild(granParent);
                continue;
            }
            this.filterElements(child, coord);
        }
    }

    public String xmlToString(Node node) {
        try {
            DOMSource source = new DOMSource(node);
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(source, result);
            return stringWriter.getBuffer().toString();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void updateCoordinates(Node parent, List<Node> nodes, Coordinates coordinates) {
        this.logger.debug((Object)" updateCoordinates method");
        for (Node node : nodes) {
            Node child;
            List<Node> childs = this.extractChild(node, "name");
            if (childs == null || (child = childs.get(0)).getTextContent().equals(coordinates.getPackageName())) continue;
            this.logger.debug((Object)("removeChild: " + child.getNodeValue() + " " + child.getLocalName()));
            node.removeChild(child);
        }
    }
}

