/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.softwaregateway.impl.repositorymanager.util;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.resolver.MultipleArtifactsNotFoundException;
import org.apache.maven.embedder.Configuration;
import org.apache.maven.embedder.ConfigurationValidationResult;
import org.apache.maven.embedder.DefaultConfiguration;
import org.apache.maven.embedder.MavenEmbedder;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.softwaregateway.impl.porttypes.ServiceContext;

public class MavenExecutor {
    private static final GCUBELog logger = new GCUBELog(MavenExecutor.class);
    private MavenEmbedder mavenEmbedder;
    private MavenExecutionRequest request;

    private File createSettingsFile(String repository) throws Exception {
        String cfgDir = (String)ServiceContext.getContext().getProperty("configDir", new boolean[]{false});
        logger.debug((Object)("ConfigDir: " + cfgDir));
        logger.debug((Object)("path to file: " + cfgDir + File.separator + "settings.xml"));
        File file = new File(cfgDir + File.separator + "settings.xml");
        return file;
    }

    public MavenExecutor(File projectDirectory, String repository, File userSettings) throws Exception {
        logger.debug((Object)"Searching settings file...");
        if (userSettings == null) {
            userSettings = this.createSettingsFile("");
        }
        DefaultConfiguration configuration = new DefaultConfiguration();
        configuration.setUserSettingsFile(userSettings).setClassLoader(Thread.currentThread().getContextClassLoader());
        ConfigurationValidationResult validationResult = MavenEmbedder.validateConfiguration((Configuration)configuration);
        logger.info((Object)"MavenExecutor configured");
        if (validationResult != null) {
            if (!validationResult.isValid()) {
                logger.info((Object)"MavenExecutor invalid results");
                String error = "User configuration file for maven not valid";
                logger.error((Object)error);
                throw new Exception(error);
            }
        } else {
            logger.error((Object)"Validation Result NULL");
            throw new Exception("Validation Result NULL");
        }
        logger.info((Object)"MavenExecutor valid results");
        this.mavenEmbedder = new MavenEmbedder((Configuration)configuration);
        this.request = new DefaultMavenExecutionRequest();
        this.request.setBaseDirectory(projectDirectory);
        logger.trace((Object)"Maven excecutor created");
    }

    public void exec(String goal, String[][] properties) throws Exception {
        logger.debug((Object)("exec method with goal: " + goal));
        logger.info((Object)"executing MavenExcecutor");
        StringBuilder stringBuilder = new StringBuilder();
        this.request.setGoals(Arrays.asList(goal));
        stringBuilder.append("Goal = ").append(goal).append("\n");
        if (properties[0].length != 2) {
            Exception e = new Exception("Invalid Properties array size");
            logger.error((Object)e);
            throw e;
        }
        for (int i = 0; i < properties.length; ++i) {
            logger.info((Object)("MAVEN request: setProperty(" + properties[i][0] + ", " + properties[i][1]));
            this.request.setProperty(properties[i][0], properties[i][1]);
            stringBuilder.append("option n.").append(i).append(" ").append(properties[i][0]).append(" = ").append(properties[i][1]).append("\n");
            logger.info((Object)"reading the properties");
        }
        logger.info((Object)("the string is:" + stringBuilder.toString()));
        MavenExecutionResult mavenResult = this.mavenEmbedder.execute(this.request);
        if (mavenResult.hasExceptions()) {
            List exceptionList = mavenResult.getExceptions();
            int i = 1;
            for (Exception exception : exceptionList) {
                logger.info((Object)("Maven Exception n." + i++ + ":\n" + exception));
                if (!(exception instanceof LifecycleExecutionException)) continue;
                logger.info((Object)"exception instanceof org.apache.maven.lifecycle.LifecycleExecutionException ");
                LifecycleExecutionException lifecycleExecutionException = (LifecycleExecutionException)exception;
                if (!(lifecycleExecutionException.getCause() instanceof MultipleArtifactsNotFoundException)) continue;
                MultipleArtifactsNotFoundException multipleArtifactsNotFoundException = (MultipleArtifactsNotFoundException)lifecycleExecutionException.getCause();
                logger.info((Object)"MultipleArtifactsNotFoundException ");
                int j = 1;
                List resolvedArtifacts = multipleArtifactsNotFoundException.getResolvedArtifacts();
                for (DefaultArtifact defaultArtifact : resolvedArtifacts) {
                    logger.info((Object)("Resolved Artifact n. " + j++ + " : " + defaultArtifact));
                }
                j = 1;
                List missingArtifacts = multipleArtifactsNotFoundException.getMissingArtifacts();
                for (DefaultArtifact defaultArtifact : missingArtifacts) {
                    logger.info((Object)("Missing Artifact n. " + j++ + " : " + defaultArtifact));
                }
            }
            throw (Exception)exceptionList.get(0);
        }
    }
}

