/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.softwaregateway.impl.repositorymanager.util;

import java.io.File;
import java.util.Date;
import java.util.List;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.resolver.MultipleArtifactsNotFoundException;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.softwaregateway.impl.porttypes.ServiceContext;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.util.MavenExecutor;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.util.MavenResultTreeParser;

public class MavenDependenciesSolver {
    public static final String DEPENDENCY_RESOLUTION = "DependencyResolutionReport";
    public static final String RESOLVED_DEPENDECIES = "ResolvedDependencies";
    public static final String MISSING_DEPENDENCIES = "MissingDependencies";
    protected final GCUBELog logger = new GCUBELog(MavenDependenciesSolver.class);

    public String dependenciesSolverFromPom(File pomFile, File projectDir, String repository, String scope) throws Exception {
        this.logger.debug((Object)"dependenciesSolverFromPom method ");
        Date d = new Date();
        String resultFileName = "resultTree.txt";
        String serviceID = "";
        String cfgDir = (String)ServiceContext.getContext().getProperty("configDir", new boolean[]{false});
        this.logger.debug((Object)("try to create the following dir: " + projectDir.getAbsolutePath()));
        if (!projectDir.exists()) {
            projectDir.mkdirs();
        }
        File resultTree = null;
        MavenExecutor mavenExecutor = null;
        String goal = null;
        try {
            this.logger.debug((Object)("MAVEN EXECUTOR WITH projectDir " + projectDir.getAbsolutePath() + "    repository  " + repository));
            mavenExecutor = new MavenExecutor(projectDir, repository, null);
        }
        catch (Exception e) {
            String error = "Error instantiating Maven Executor ";
            this.logger.error((Object)error);
            throw e;
        }
        try {
            goal = "dependency:tree";
            resultTree = new File(projectDir, "resultTree.txt");
            String[][] properties = new String[1][2];
            properties[0][0] = "outputFile";
            properties[0][1] = resultTree.getAbsolutePath();
            this.logger.debug((Object)("executing goals : " + goal + " with outputFile=" + properties[0][1]));
            mavenExecutor.exec(goal, properties);
        }
        catch (Exception e) {
            block22: {
                String error = "Error executing goals : " + goal;
                try {
                    this.logger.info((Object)("error," + e.getMessage()));
                    if (!(e instanceof LifecycleExecutionException)) break block22;
                    LifecycleExecutionException lifecycleExecutionException = (LifecycleExecutionException)e;
                    if (lifecycleExecutionException.getCause() instanceof MultipleArtifactsNotFoundException) {
                        MultipleArtifactsNotFoundException multipleArtifactsNotFoundException = (MultipleArtifactsNotFoundException)lifecycleExecutionException.getCause();
                        List resolvedArtifacts = multipleArtifactsNotFoundException.getResolvedArtifacts();
                        List missingArtifacts = multipleArtifactsNotFoundException.getMissingArtifacts();
                        if (resolvedArtifacts != null && missingArtifacts != null) {
                            this.logger.info((Object)"entered in th first if ...");
                            StringBuffer sb = new StringBuffer();
                            sb.append("<").append(DEPENDENCY_RESOLUTION).append(">\n");
                            sb.append("<").append(RESOLVED_DEPENDECIES).append(">\n");
                            this.logger.info((Object)("the resolved dependencies are " + resolvedArtifacts.size()));
                            for (int j = 0; j < resolvedArtifacts.size(); ++j) {
                                DefaultArtifact defaultArtifact = (DefaultArtifact)resolvedArtifacts.get(j);
                                this.logger.info((Object)("Resolved Artifact n. " + j + " : " + defaultArtifact));
                                try {
                                    sb.append(MavenResultTreeParser.getArtifactInfo(defaultArtifact.toString()).toXML("Dependency", defaultArtifact));
                                    continue;
                                }
                                catch (Exception e1) {
                                    this.logger.info((Object)e1);
                                    throw e1;
                                }
                            }
                            sb.append("</").append(RESOLVED_DEPENDECIES).append(">\n");
                            sb.append("<").append(MISSING_DEPENDENCIES).append(">\n");
                            for (int k = 0; k < missingArtifacts.size(); ++k) {
                                DefaultArtifact defaultArtifact = (DefaultArtifact)missingArtifacts.get(k);
                                this.logger.info((Object)("Missing Artifact n. " + k + " : " + defaultArtifact));
                                try {
                                    sb.append(MavenResultTreeParser.getArtifactInfo(defaultArtifact.toString()).toXML("MissingDependency", defaultArtifact));
                                    continue;
                                }
                                catch (Exception e1) {
                                    this.logger.info((Object)e1);
                                    e1.printStackTrace();
                                    throw e1;
                                }
                            }
                            sb.append("</").append(MISSING_DEPENDENCIES).append(">\n");
                            sb.append("</").append(DEPENDENCY_RESOLUTION).append(">\n");
                            return sb.toString();
                        }
                        break block22;
                    }
                    if (!(lifecycleExecutionException.getCause() instanceof OverConstrainedVersionException)) break block22;
                    OverConstrainedVersionException cause = (OverConstrainedVersionException)lifecycleExecutionException.getCause();
                    DefaultArtifact defaultArtifact = (DefaultArtifact)cause.getArtifact();
                    StringBuffer sb = new StringBuffer();
                    sb.append("<").append(DEPENDENCY_RESOLUTION).append(">\n");
                    sb.append("<").append(MISSING_DEPENDENCIES).append(">\n");
                    try {
                        this.logger.info((Object)("Missing Artifact  : " + defaultArtifact));
                        sb.append(MavenResultTreeParser.getArtifactInfo(defaultArtifact.toString()).toXML("MissingDependency"));
                    }
                    catch (Exception e1) {
                        this.logger.info((Object)e1);
                        throw e1;
                    }
                    sb.append("</").append(MISSING_DEPENDENCIES).append(">\n");
                    sb.append("</").append(DEPENDENCY_RESOLUTION).append(">\n");
                    this.logger.info((Object)("OUT:    " + sb.toString()));
                    sb.append("</").append(DEPENDENCY_RESOLUTION).append(">\n");
                    return sb.toString();
                }
                catch (Exception pe) {
                    this.logger.error((Object)("null pointer Exception" + pe));
                    pe.printStackTrace();
                }
            }
            throw e;
        }
        try {
            this.logger.info((Object)"Parsing dependency tree");
            MavenResultTreeParser treeParser = new MavenResultTreeParser(resultTree);
            treeParser.getScopedDependecy(scope);
            StringBuffer sb = new StringBuffer();
            sb.append("<").append(DEPENDENCY_RESOLUTION).append(">\n");
            sb.append(treeParser.listDependency());
            sb.append("</").append(DEPENDENCY_RESOLUTION).append(">\n");
            this.logger.info((Object)("OUT:    " + sb.toString()));
            String pe = sb.toString();
            return pe;
        }
        catch (Exception e) {
            e.printStackTrace();
            String error = "Error resolving tree dependency";
            this.logger.info((Object)("error," + e.getMessage()));
            throw e;
        }
        finally {
            this.logger.info((Object)(projectDir.getAbsoluteFile() + " not removed for debug issue"));
        }
    }
}

