/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.softwaregateway.impl.repositorymanager.maven;

import org.apache.maven.artifact.DefaultArtifact;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.softwaregateway.impl.coordinates.Coordinates;
import org.gcube.vremanagement.softwaregateway.impl.coordinates.MavenCoordinates;
import org.gcube.vremanagement.softwaregateway.impl.exceptions.BadCoordinatesException;
import org.gcube.vremanagement.softwaregateway.impl.exceptions.ServiceNotAvaiableFault;

public class ArtifactCoordinates {
    private static final GCUBELog logger = new GCUBELog(ArtifactCoordinates.class);
    private String groupID;
    private String artifactID;
    private String artifactVersion;
    private String artifactDescription = null;
    private String packaging = "tar.gz";
    private String classifier = null;
    private String scope = "runtime";
    private boolean optional = false;

    public ArtifactCoordinates(String groupID, String artifactID, String artifactVersion, String scope, String classifier) throws Exception {
        if (groupID == null || groupID.compareTo("") == 0) {
            IllegalArgumentException e = new IllegalArgumentException();
            logger.debug((Object)e);
            throw e;
        }
        this.groupID = groupID;
        if (artifactID == null || artifactID.compareTo("") == 0) {
            IllegalArgumentException e = new IllegalArgumentException();
            logger.debug((Object)e);
            throw e;
        }
        this.artifactID = artifactID;
        if (artifactVersion == null || artifactVersion.compareTo("") == 0) {
            IllegalArgumentException e = new IllegalArgumentException();
            logger.debug((Object)e);
            throw e;
        }
        this.artifactVersion = artifactVersion;
        this.scope = scope;
        this.classifier = classifier;
    }

    public String toString() {
        return this.groupID + ":" + this.artifactID + ":" + this.packaging + ":" + (this.classifier != null ? this.classifier + ":" : "") + this.artifactVersion + ":" + this.scope;
    }

    public String toXML(String rootTag) throws ServiceNotAvaiableFault {
        logger.debug((Object)("rootTag: " + rootTag));
        logger.debug((Object)("rootTag: " + this.groupID));
        logger.debug((Object)("rootTag: " + this.artifactID));
        logger.debug((Object)("rootTag: " + this.artifactVersion));
        StringBuilder sb = new StringBuilder();
        sb.append("<" + rootTag + ">" + "\n");
        sb.append("\t<Service>\n");
        Coordinates gc = null;
        try {
            MavenCoordinates mc = new MavenCoordinates(this.groupID, this.artifactID, this.artifactVersion);
            gc = mc.getGcubeCoordinates();
        }
        catch (BadCoordinatesException e) {
            e.printStackTrace();
        }
        String serviceClass = gc.getServiceClass();
        String serviceName = gc.getServiceName();
        String serviceVersion = gc.getServiceVersion();
        String packageName = gc.getPackageName();
        String packageVersion = gc.getPackageVersion();
        sb.append("\t\t<Class>").append(serviceClass).append("</Class>\n");
        sb.append("\t\t<Name>").append(serviceName).append("</Name>\n");
        sb.append("\t\t<Version>").append(serviceVersion).append("</Version>\n");
        sb.append("\t</Service>\n");
        logger.debug((Object)("ArtifactID = " + this.artifactID));
        sb.append("\t<Package>").append(packageName).append("</Package>\n");
        logger.debug((Object)("Version = " + this.artifactVersion));
        sb.append("\t<Version>").append(packageVersion).append("</Version>\n");
        sb.append("</" + rootTag + ">\n");
        return sb.toString();
    }

    public String getArtifactID() {
        return this.artifactID;
    }

    public String getGroupID() {
        return this.groupID;
    }

    public String getArtifactVersion() {
        return this.artifactVersion;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getArtifactDescription() {
        return this.artifactDescription;
    }

    public void setArtifactDescription(String artifactDescription) {
        this.artifactDescription = artifactDescription;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public String toXML(String rootTag, DefaultArtifact artifact) throws ServiceNotAvaiableFault {
        StringBuilder sb = new StringBuilder();
        sb.append("<" + rootTag + ">" + "\n");
        sb.append("\t<Service>\n");
        Coordinates gc = null;
        try {
            MavenCoordinates mc = new MavenCoordinates(this.groupID, this.artifactID, this.artifactVersion);
            gc = mc.getGcubeCoordinates();
        }
        catch (BadCoordinatesException e) {
            e.printStackTrace();
        }
        String serviceClass = gc.getServiceClass();
        String serviceName = gc.getServiceName();
        String serviceVersion = gc.getServiceVersion();
        String packageName = gc.getPackageName();
        String packageVersion = gc.getPackageVersion();
        sb.append("\t\t<Class>").append(serviceClass).append("</Class>\n");
        sb.append("\t\t<Name>").append(serviceName).append("</Name>\n");
        sb.append("\t\t<Version>").append(serviceVersion).append("</Version>\n");
        sb.append("\t</Service>\n");
        logger.debug((Object)("ArtifactID = " + this.artifactID));
        sb.append("\t<Package>").append(packageName).append("</Package>\n");
        logger.debug((Object)("Version = " + this.artifactVersion));
        sb.append("\t<Package>").append(packageVersion).append("</Package>\n");
        sb.append("</" + rootTag + ">\n");
        return sb.toString();
    }
}

