/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.softwaregateway.webserver.impl.jetty;

import java.io.IOException;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.softwaregateway.webserver.WebServer;
import org.gcube.vremanagement.softwaregateway.webserver.impl.jetty.JettyWebServerLogger;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ResourceHandler;
import org.mortbay.jetty.nio.SelectChannelConnector;

public class JettyWebServer
implements WebServer {
    protected static final GCUBELog logger = new GCUBELog(JettyWebServer.class);
    protected static final JettyWebServerLogger webServerLogger = new JettyWebServerLogger();
    private Server server = new Server();

    @Override
    public void initDefaults(String basePath, int port) {
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(port);
        this.server.setConnectors(new Connector[]{connector});
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setResourceBase(basePath);
        try {
            logger.debug((Object)("HTTP Server Base Path : " + resourceHandler.getBaseResource().getFile().getAbsolutePath()));
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        this.server.setHandler((Handler)resourceHandler);
    }

    public void setConnectors(Connector[] connectors) {
        this.server.setConnectors(connectors);
    }

    public void setHandlers(Handler[] handlers) {
        this.server.setHandlers(handlers);
    }

    @Override
    public void startServer() throws Exception {
        try {
            this.server.start();
        }
        catch (Exception e) {
            String error = "Error while starting WebServer";
            logger.error((Object)error, (Throwable)e);
        }
    }

    @Override
    public String getBaseUrl() {
        ResourceHandler rh = (ResourceHandler)this.server.getHandler();
        return rh.getBaseResource().getURL().toString();
    }
}

