/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.softwaregateway.impl.repositorymanager.cache;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.CacheEventListenerAdapter;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.softwaregateway.impl.coordinates.Coordinates;
import org.gcube.vremanagement.softwaregateway.impl.coordinates.MavenCoordinates;
import org.gcube.vremanagement.softwaregateway.impl.exceptions.ServiceNotAvaiableFault;
import org.gcube.vremanagement.softwaregateway.impl.porttypes.ServiceContext;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.RepositoryManager;

public class NexusCache
extends RepositoryManager {
    private CacheManager cacheManager;
    private Cache cache;
    protected final GCUBELog logger = new GCUBELog(NexusCache.class);
    private static final int MAXIMUM_SIZE = 1000;
    private static final boolean OVERFLOW_TO_DISK = false;
    private static final String CACHE_NAME = "softwaregateway-nexuscache";
    public static final String CACHE_STRING_SEPARATOR = "-_-";
    private static NexusCache singleton;

    private NexusCache(String[] mavenServerList) {
        super(mavenServerList);
        this.logger.debug((Object)"Instantiated");
        try {
            this.cacheManager = this.getDefaultCacheManagerConfiguration();
            this.logger.info((Object)("cachemanager returned is: " + this.cacheManager));
            String[] cacheNames = this.cacheManager.getCacheNames();
            this.logger.debug((Object)"NEXUSCACHE FOUND IN CONFIGURATION FILE: ");
            for (String s : cacheNames) {
                this.logger.debug((Object)("CaChE " + s));
            }
            this.cache = this.cacheManager.getCache(CACHE_NAME);
        }
        catch (Exception e) {
            this.logger.error((Object)("error cache: " + e.getMessage()));
            e.printStackTrace();
        }
        if (this.cache == null) {
            this.logger.info((Object)"CACHE ADDED: softwaregateway-nexuscache");
            this.cacheManager.addCache(CACHE_NAME);
            this.cache = this.cacheManager.getCache(CACHE_NAME);
        }
        this.cache.getCacheEventNotificationService().registerListener((CacheEventListener)new CacheEventListenerAdapter(){

            public void notifyRemoveAll(Ehcache cache) {
                NexusCache.this.logger.info((Object)(" notifyRemoveAll in cache " + cache.getName()));
            }

            public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
                NexusCache.this.logger.info((Object)(" notifyElementUpdated in cache " + cache.getName() + " element: " + element.getKey()));
            }

            public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
                NexusCache.this.logger.info((Object)(" notifyElementRemoved in cache " + cache.getName() + " element: " + element.getKey()));
            }

            public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
                NexusCache.this.logger.info((Object)(" notifyElementPut in cache " + cache.getName() + " element: " + element.getKey()));
            }

            public void notifyElementExpired(Ehcache cache, Element element) {
                NexusCache.this.logger.info((Object)(" notifyElementExpired in cache " + cache.getName() + " element: " + element.getKey()));
                String type = this.getElementType(element);
                if (!type.equalsIgnoreCase("url")) {
                    if (type.equalsIgnoreCase("mavenCoordinates") || type.equalsIgnoreCase("gcubeCoordinates")) {
                        String url = (String)((Object)element.getValue());
                        int statusCode = 0;
                        try {
                            statusCode = new HttpClient().executeMethod((HttpMethod)new GetMethod(url));
                        }
                        catch (HttpException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        if (statusCode == 200) {
                            NexusCache.this.logger.debug((Object)("the element " + (String)((Object)element.getKey()) + " is alive "));
                            NexusCache.this.put(element.getKey(), element.getValue());
                        }
                    } else {
                        NexusCache.this.logger.info((Object)"element in cache not recognized");
                    }
                }
            }

            private String getElementType(Element element) {
                NexusCache.this.logger.debug((Object)"check Element");
                String type = "unknowed";
                String key = (String)((Object)element.getKey());
                String[] params = key.split(NexusCache.CACHE_STRING_SEPARATOR);
                if (params != null) {
                    NexusCache.this.logger.debug((Object)("number of params found in cache string: " + params.length));
                    if (params.length < 2) {
                        type = "url";
                    } else if (params.length == 4) {
                        type = "mavenCoordinates";
                    } else if (params.length == 6) {
                        type = "gcubeCoordinates";
                    }
                    NexusCache.this.logger.debug((Object)("element in cache is a " + type + " object"));
                }
                return type;
            }

            public void notifyElementEvicted(Ehcache cache, Element element) {
                NexusCache.this.logger.info((Object)(" notifyElementEvicted in cache " + cache.getName() + " element: " + element.getKey()));
            }

            public void dispose() {
            }
        });
        this.logger.debug((Object)"cache instantiated");
    }

    public static NexusCache getInstance(String[] mavenServerList) {
        if (singleton == null) {
            singleton = new NexusCache(mavenServerList);
        }
        return singleton;
    }

    @Override
    public String get(Object mavenC, String extension, String classifier) throws MalformedURLException, ServiceNotAvaiableFault {
        String cacheCoordinates;
        Element element;
        MavenCoordinates mc = (MavenCoordinates)mavenC;
        if (mc != null && (element = this.cache.get((Serializable)((Object)(cacheCoordinates = this.buildMavenCoordinatesCacheInputString(mc, extension, classifier))))) != null) {
            this.logger.info((Object)"CACHE FETCHING");
            return (String)((Object)element.getValue());
        }
        return null;
    }

    @Override
    public String extractDepsFromMavenEmb(String url) throws ServiceNotAvaiableFault {
        Element element = this.cache.get((Serializable)((Object)url));
        if (element != null) {
            this.logger.info((Object)"CACHE FETCHING");
            return (String)((Object)element.getValue());
        }
        return null;
    }

    @Override
    public String searchArtifact(String baseUrl, String groupName, String artifact, String extension, String ver, boolean pom, String classifier) throws MalformedURLException {
        return null;
    }

    public void put(Object key, Object value) {
        this.logger.info((Object)"CACHE: ELEMENT INSERTING");
        this.cache.put(new Element(key, value));
    }

    public void remove(String cacheElement) {
        this.logger.info((Object)("cache element deleted: " + cacheElement));
        this.cache.remove((Serializable)((Object)cacheElement));
    }

    private CacheManager getDefaultCacheManagerConfiguration() {
        String cfgDir = (String)ServiceContext.getContext().getProperty("configDir", new boolean[]{false});
        this.logger.debug((Object)("ConfigDir for cache: " + cfgDir));
        this.logger.debug((Object)("path to file: " + cfgDir + File.separator + "ehcache.xml"));
        File cacheFile = new File(cfgDir + File.separator + "ehcache.xml");
        if (cacheFile.exists()) {
            this.logger.debug((Object)"ehcache.xml exist");
            if (cacheFile.canRead()) {
                this.logger.debug((Object)"ehcache.xml canRead");
            } else {
                this.logger.debug((Object)"ehcache.xml can't Read");
            }
            if (cacheFile.canWrite()) {
                this.logger.debug((Object)"ehcache.xml canWrite");
            } else {
                this.logger.debug((Object)"ehcache.xml can't Write");
            }
        } else {
            this.logger.debug((Object)"ehcache.xml is unreachable");
        }
        this.logger.debug((Object)"try to create cache manager ");
        return CacheManager.create((String)(cfgDir + File.separator + "ehcache.xml"));
    }

    @Override
    public String getSALocation(File tmpTargetDirectory, List<MavenCoordinates> mcList, Coordinates coordinates) throws MalformedURLException, ServiceNotAvaiableFault, IOException, Exception {
        String cacheInputString = this.buildGCubeCoordinatesCacheInputString(coordinates, "tar.gz", "servicearchive");
        Element element = this.cache.get((Serializable)((Object)cacheInputString));
        if (element != null) {
            return (String)((Object)element.getValue());
        }
        return null;
    }

    public String buildGCubeCoordinatesCacheInputString(Coordinates coordinates, String extension, String classifier) {
        if (classifier == null) {
            return coordinates.getServiceClass() + CACHE_STRING_SEPARATOR + coordinates.getServiceName() + CACHE_STRING_SEPARATOR + coordinates.getServiceVersion() + CACHE_STRING_SEPARATOR + coordinates.getPackageName() + CACHE_STRING_SEPARATOR + coordinates.getPackageVersion() + CACHE_STRING_SEPARATOR + extension;
        }
        return coordinates.getServiceClass() + CACHE_STRING_SEPARATOR + coordinates.getServiceName() + CACHE_STRING_SEPARATOR + coordinates.getServiceVersion() + CACHE_STRING_SEPARATOR + coordinates.getPackageName() + CACHE_STRING_SEPARATOR + coordinates.getPackageVersion() + CACHE_STRING_SEPARATOR + extension + CACHE_STRING_SEPARATOR + classifier;
    }

    public String buildMavenCoordinatesCacheInputString(Coordinates coordinates, String extension, String classifier) {
        if (classifier == null) {
            return coordinates.getGroupId() + CACHE_STRING_SEPARATOR + coordinates.getArtifactId() + CACHE_STRING_SEPARATOR + coordinates.getVersion() + CACHE_STRING_SEPARATOR + extension;
        }
        return coordinates.getGroupId() + CACHE_STRING_SEPARATOR + coordinates.getArtifactId() + CACHE_STRING_SEPARATOR + coordinates.getVersion() + CACHE_STRING_SEPARATOR + extension + CACHE_STRING_SEPARATOR + classifier;
    }
}

