/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.softwaregateway.impl.repositorymanager.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.GregorianCalendar;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.w3c.dom.Document;

public class FileUtilsExtended {
    protected static final GCUBELog logger = new GCUBELog(FileUtilsExtended.class);

    public static boolean recursiveDeleteDirectory(File directory) {
        if (directory.exists() && directory.isDirectory()) {
            File[] list;
            for (File item : list = directory.listFiles()) {
                boolean deleted;
                if (!(item.isFile() ? !(deleted = item.delete()) : item.isDirectory() && !FileUtilsExtended.recursiveDeleteDirectory(item))) continue;
                return false;
            }
        } else {
            return false;
        }
        return directory.delete();
    }

    public static void stringToFile(String str, File targetFile) throws IOException {
        try {
            FileWriter fw = new FileWriter(targetFile);
            fw.write(str);
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw e;
        }
    }

    public static String fileToString(String absolutePath) throws Exception {
        BufferedReader filebuf = null;
        String nextStr = null;
        StringBuilder ret = new StringBuilder();
        try {
            filebuf = new BufferedReader(new FileReader(absolutePath));
            nextStr = filebuf.readLine();
            while (nextStr != null) {
                ret.append(nextStr);
                nextStr = filebuf.readLine();
            }
            filebuf.close();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e);
            throw e;
        }
        catch (IOException e1) {
            logger.error((Object)e1);
            throw e1;
        }
        return ret.toString();
    }

    public static String dateDirectory() {
        GregorianCalendar calendar = new GregorianCalendar();
        int day = calendar.get(5);
        String dayString = day < 10 ? "0" + day : "" + day;
        int month = calendar.get(2) + 1;
        String monthString = month < 10 ? "0" + month : "" + month;
        int year = calendar.get(1);
        String dateDir = dayString + "-" + monthString + "-" + year;
        return dateDir;
    }

    public static void writeXmlToFile(Document document, File file) throws Exception {
        try {
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new FileOutputStream(file));
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.setOutputProperty("indent", "yes");
            xformer.transform(source, result);
        }
        catch (Exception e) {
            logger.error((Object)"Error while serializing xml on file", (Throwable)e);
            throw e;
        }
    }

    public static void copyFile(File source, File target) throws Exception {
        int len;
        FileInputStream in = new FileInputStream(source);
        FileOutputStream out = new FileOutputStream(target);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }
}

