/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.softwaregateway.impl.is;

import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gcube.common.core.informationsystem.ISException;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericResourceQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERuntimeResourceQuery;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.softwaregateway.impl.coordinates.Coordinates;
import org.gcube.vremanagement.softwaregateway.impl.coordinates.GCubeCoordinates;
import org.gcube.vremanagement.softwaregateway.impl.coordinates.MavenCoordinates;
import org.gcube.vremanagement.softwaregateway.impl.exceptions.BadCoordinatesException;
import org.gcube.vremanagement.softwaregateway.impl.exceptions.ServiceNotAvaiableFault;
import org.gcube.vremanagement.softwaregateway.impl.is.ISCache;
import org.gcube.vremanagement.softwaregateway.impl.is.ISManager;
import org.gcube.vremanagement.softwaregateway.impl.packages.GCubePackage;
import org.gcube.vremanagement.softwaregateway.impl.packages.MavenPackage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ISProxy
extends ISManager {
    private ISCache cache;
    private static HashMap serverCache;
    protected final GCUBELog logger = new GCUBELog(ISProxy.class);

    public ISProxy(GCUBEScope gCubeScope, boolean cacheEnabled) {
        super(gCubeScope);
        this.logger.trace((Object)"creating IS proxy...");
        this.cacheEnabled = cacheEnabled;
        if (cacheEnabled) {
            this.logger.trace((Object)"cache is enabled");
            this.cache = ISCache.getInstance();
        }
        serverCache = new HashMap();
    }

    @Override
    public MavenCoordinates getMavenCoordinates(Coordinates coordinates) throws ISException {
        this.logger.trace((Object)"getMavenCoordinates method ");
        MavenCoordinates mCoordinates = null;
        if (mCoordinates == null && (mCoordinates = this.queryMavenCoordinates(coordinates.getServiceName(), coordinates.getServiceClass(), coordinates.getServiceVersion(), coordinates.getPackageName(), coordinates.getPackageVersion())) != null && this.cacheEnabled) {
            this.cache.put(coordinates, mCoordinates);
        }
        return mCoordinates;
    }

    public MavenCoordinates getSAMavenCoordinates(Coordinates coordinates) throws ISException {
        this.logger.trace((Object)"getSAMavenCoordinates method ");
        MavenCoordinates mCoordinates = null;
        if (mCoordinates == null) {
            mCoordinates = this.querySAMavenCoordinates(coordinates.getServiceName(), coordinates.getServiceClass(), coordinates.getServiceVersion(), coordinates.getPackageName(), coordinates.getPackageVersion());
        }
        return mCoordinates;
    }

    public GCubeCoordinates getGcubeCoordinates(MavenCoordinates mavenC) throws ISException, BadCoordinatesException {
        GCubeCoordinates gCoordinates = null;
        if (this.cacheEnabled) {
            gCoordinates = this.cache.getGcubeCoordinates(mavenC);
        } else {
            this.logger.info((Object)"Cache not enabled");
        }
        if (gCoordinates == null) {
            gCoordinates = this.queryGCubeCoordinates(mavenC.getGroupId(), mavenC.getArtifactId(), mavenC.getVersion());
            if (gCoordinates != null) {
                this.logger.info((Object)("gcube coordinates found: sc " + gCoordinates.getServiceClass() + " sn " + gCoordinates.getServiceName() + " sv " + gCoordinates.getPackageName() + " "));
            }
            if (gCoordinates != null && this.cacheEnabled) {
                this.logger.info((Object)"CACHE ELEMENT INSERTED");
                this.cache.put(mavenC, gCoordinates);
            }
        }
        return gCoordinates;
    }

    @Override
    public void updateProfile(String xml) {
    }

    @Override
    public List<URL> getMavenConfiguration() {
        List<URL> list = null;
        return list;
    }

    @Deprecated
    public String[] getMavenServerListFromGR(GCUBEScope scope) throws Exception {
        this.logger.trace((Object)("getMavenServerList method call for retrieve server list from scope: " + scope.getName()));
        GCUBEGenericResourceQuery query = (GCUBEGenericResourceQuery)this.getIsClient().getQuery(GCUBEGenericResourceQuery.class);
        query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/Name", "SoftwareGateway")});
        for (GCUBEGenericResource resource : this.isClient.execute((ISQuery)query, scope)) {
            String body = resource.getBody();
            this.server = this.parseXmlFile(new InputSource(new StringReader(body)));
        }
        if (this.server != null) {
            this.logger.debug((Object)("server found: " + this.server.length));
            for (String s : this.server) {
                this.logger.debug((Object)("server: " + s));
            }
            this.logger.info((Object)("number of servers : " + this.server.length));
        }
        if (this.server == null || this.server.length == 0) {
            this.logger.info((Object)"server not found try in enclosing scope if it is a VRE scope");
            GCUBEScope.Type scopeType = scope.getType();
            this.logger.info((Object)("scope type: " + GCUBEScope.Type.VRE + " equals to  " + GCUBEScope.Type.VRE));
            if (GCUBEScope.Type.VRE == GCUBEScope.Type.VRE) {
                this.logger.info((Object)"VRE scope try enclosing scope");
                GCUBEScope newScope = scope.getEnclosingScope();
                this.logger.info((Object)("enclosing scope found: " + newScope));
                if (newScope != null) {
                    this.server = this.getMavenServerListFromGR(newScope);
                } else {
                    return this.server;
                }
            }
        }
        return this.server;
    }

    public String[] getMavenServerListFromRR(GCUBEScope scope) throws ServiceNotAvaiableFault {
        List<String> serverList = new ArrayList();
        String host = null;
        this.logger.trace((Object)("getMavenServerList method call for retrieve server list from scope: " + scope.getName()));
        if (serverCache == null || serverCache.get(scope.getName()) == null) {
            GCUBERuntimeResourceQuery query;
            this.logger.debug((Object)"server cache empty for this scope ");
            List resources = null;
            try {
                query = (GCUBERuntimeResourceQuery)this.getIsClient().getQuery(GCUBERuntimeResourceQuery.class);
            }
            catch (Exception e) {
                this.logger.error((Object)"Problem on getQuery method. Impossible to retrieve GCUBERuntimeResourceQuery ");
                throw new ServiceNotAvaiableFault(e.getMessage());
            }
            query.clearConditions();
            query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/Name", "MavenRepository")});
            try {
                this.logger.debug((Object)("start query execution in scope " + scope.getName()));
                resources = this.isClient.execute((ISQuery)query, scope);
            }
            catch (ISException e) {
                this.logger.error((Object)"ISException thrown when executing query");
                throw new ServiceNotAvaiableFault(e.getMessage());
            }
            catch (Exception e) {
                this.logger.error((Object)"ISException thrown when executing query");
                throw new ServiceNotAvaiableFault(e.getMessage());
            }
            if (resources != null) {
                this.logger.debug((Object)("resources found: " + resources.size()));
                for (GCUBERuntimeResource resource : resources) {
                    if (host != null && (host == null || host.equals(resource.getHostedOn()))) continue;
                    host = resource.getHostedOn();
                    this.logger.debug((Object)("host found " + host));
                    String url = "http://" + host + "/nexus";
                    serverList.add(url);
                }
            } else {
                this.logger.debug((Object)"no resources found on IS ");
            }
            if (!serverList.isEmpty()) {
                this.logger.debug((Object)"caching maven server");
                serverCache.put(scope.getName(), serverList);
            }
        } else {
            if (serverCache == null) {
                serverCache = new HashMap();
            }
            serverList = (List)serverCache.get(scope.getName());
            this.logger.debug((Object)("retrieve from cache: " + serverList));
        }
        if (serverList != null && !serverList.isEmpty()) {
            this.server = new String[serverList.size()];
            int i = 0;
            for (String s : serverList) {
                this.server[i] = (String)serverList.get(i);
                ++i;
            }
        } else {
            this.server = null;
        }
        if (this.server != null) {
            this.logger.debug((Object)("server found: " + this.server.length));
            for (String s : this.server) {
                this.logger.debug((Object)("server: " + s));
            }
            this.logger.info((Object)("number of servers : " + this.server.length));
        }
        if (this.server == null || this.server.length == 0) {
            this.logger.info((Object)("server not found on scope:" + scope.getName() + " try on enclosing scope "));
            GCUBEScope.Type scopeType = scope.getType();
            if (GCUBEScope.Type.VRE == GCUBEScope.Type.VRE) {
                GCUBEScope newScope = scope.getEnclosingScope();
                this.logger.debug((Object)("enclosing scope found: " + newScope));
                if (newScope != null) {
                    this.server = this.getMavenServerListFromRR(newScope);
                } else {
                    return this.server;
                }
            }
        }
        return this.server;
    }

    private String[] parseXmlFile(InputSource body) {
        String[] list = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(body);
            doc.getDocumentElement().normalize();
            NodeList nodeLst = doc.getElementsByTagName("server_list");
            int i = 0;
            list = new String[nodeLst.getLength()];
            for (int s = 0; s < nodeLst.getLength(); ++s) {
                String ip;
                Node fstNode = nodeLst.item(s);
                if (fstNode.getNodeType() != 1) continue;
                Element fstElmnt = (Element)fstNode;
                NodeList fstNmElmntLst = fstElmnt.getElementsByTagName("server");
                Element fstNmElmnt = (Element)fstNmElmntLst.item(0);
                list[i] = ip = fstNmElmnt.getAttribute("url");
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public List<MavenPackage> getMavenPackagesCoordinates(GCubeCoordinates gcubeC) throws ISException {
        List<MavenPackage> coordList = null;
        if (this.cacheEnabled) {
            coordList = this.cache.getMavenPackagesCoordinates(gcubeC);
        }
        if (coordList == null && (coordList = this.queryMavenPackagesCoordinates(gcubeC.getServiceName(), gcubeC.getServiceClass(), gcubeC.getServiceVersion(), gcubeC.getPackageName(), gcubeC.getPackageVersion())) != null && this.cacheEnabled) {
            this.cache.put(gcubeC, coordList);
        }
        return coordList;
    }

    public List<GCubePackage> getGCubePackagesCoordinates(Coordinates coordinates) throws ISException {
        this.logger.trace((Object)"getGCUbePackagesCoordinates method");
        List<GCubePackage> coordList = null;
        if (this.cacheEnabled) {
            coordList = this.cache.getGCubePackagesCoordinates(coordinates);
        }
        if (coordList == null && (coordList = this.queryGCubePackagesCoordinates(coordinates.getServiceName(), coordinates.getServiceClass(), coordinates.getServiceVersion(), coordinates.getPackageName(), coordinates.getPackageVersion())) != null && this.cacheEnabled) {
            this.cache.put(coordinates, coordList);
        }
        return coordList;
    }

    @Override
    public List<GCubePackage> getPluginCoordinates(Coordinates coordinates) throws ISException {
        this.logger.trace((Object)" getPlugin method");
        List<GCubePackage> coordList = null;
        if (this.cacheEnabled) {
            coordList = this.cache.getPluginCoordinates(coordinates);
        }
        if (coordList == null && (coordList = this.queryPluginCoordinates(coordinates.getServiceName(), coordinates.getServiceClass(), coordinates.getServiceVersion(), coordinates.getPackageName(), coordinates.getPackageVersion())) != null && this.cacheEnabled) {
            this.cache.put(coordinates, coordList);
        }
        return coordList;
    }
}

