/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.virtualplatform.tomcat;

import java.io.File;
import java.io.FileFilter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import org.apache.catalina.ant.DeployTask;
import org.apache.catalina.ant.StartTask;
import org.apache.catalina.ant.StopTask;
import org.apache.catalina.ant.UndeployTask;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.gcube.vremanagement.virtualplatform.model.DeployedPackage;
import org.gcube.vremanagement.virtualplatform.model.PackageSet;
import org.gcube.vremanagement.virtualplatform.model.TargetPlatform;
import org.gcube.vremanagement.virtualplatform.model.UndeployedPackage;
import org.gcube.vremanagement.virtualplatform.tomcat.DeployedWebapp;
import org.gcube.vremanagement.virtualplatform.tomcat.UndeployedWebapp;
import org.gcube.vremanagement.virtualplatform.tomcat.Webapp;

public class Container
extends TargetPlatform<Webapp> {
    String user;
    String password;
    String manager;
    URL baseURL;
    static final String platform = "TOMCAT";
    static final int platformVersion = 6;
    static final int platformMinorVersion = 0;

    public DeployedPackage deploy(Webapp app) throws Exception {
        DeployedWebapp deployedApp = new DeployedWebapp(app);
        try {
            DeployTask task = new DeployTask();
            task.setProject(new Project());
            task.setUsername(this.user);
            task.setPassword(this.password);
            task.setWar(app.getFile().getAbsolutePath());
            task.setPath(app.getTargetPath());
            task.setUrl(this.manager);
            task.setDescription(app.getDescription());
            task.execute();
        }
        catch (Exception e) {
            for (StackTraceElement st : e.getStackTrace()) {
                System.err.println("Container says: " + st);
            }
            throw new Exception(e);
        }
        List sourceEprs = app.getEntrypoints();
        String[] eprs = new String[sourceEprs.size() + 1];
        eprs[0] = this.baseURL.toString() + (app.getTargetPath().startsWith("/") ? app.getTargetPath() : "/" + app.getTargetPath());
        for (int i = 0; i < sourceEprs.size(); ++i) {
            eprs[i + 1] = eprs[0] + (((String)sourceEprs.get(i)).startsWith("/") ? (String)sourceEprs.get(i) : "/" + (String)sourceEprs.get(i));
        }
        deployedApp.setEndpoints(eprs);
        deployedApp.setSuccess(true);
        return deployedApp;
    }

    public UndeployedPackage undeploy(Webapp app) throws Exception {
        UndeployedWebapp undeployedApp = new UndeployedWebapp(app);
        try {
            UndeployTask task = new UndeployTask();
            task.setProject(new Project());
            task.setUrl(this.manager);
            task.setUsername(this.user);
            task.setPassword(this.password);
            task.setPath(app.getTargetPath());
            task.execute();
        }
        catch (BuildException e) {
            throw new Exception(e);
        }
        undeployedApp.setSuccess(true);
        return undeployedApp;
    }

    public String getPlatform() {
        return platform;
    }

    public int getPlatformVersion() {
        return 6;
    }

    public int getPlatformMinorVersion() {
        return 0;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setBaseURL(URL baseURL) {
        this.baseURL = baseURL;
        this.manager = baseURL.toString() + "/manager";
    }

    public Class<Webapp> getResourceClass() {
        return Webapp.class;
    }

    public boolean activate(Webapp resource) throws Exception {
        StartTask task = new StartTask();
        task.setPath(resource.getTargetPath());
        task.setUsername(this.user);
        task.setPassword(this.password);
        task.setUrl(this.manager);
        try {
            task.execute();
        }
        catch (BuildException e) {
            throw new Exception(e);
        }
        return true;
    }

    public boolean deactivate(Webapp resource) throws Exception {
        StopTask task = new StopTask();
        task.setPath(resource.getTargetPath());
        task.setUsername(this.user);
        task.setPassword(this.password);
        task.setUrl(this.manager);
        try {
            task.execute();
        }
        catch (BuildException e) {
            throw new Exception(e);
        }
        return true;
    }

    public PackageSet<Webapp> list() throws Exception {
        return null;
    }

    public void initialize() throws Exception {
    }

    public FileFilter getAcceptedFilesFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getAbsolutePath().endsWith(".war") && file.exists();
            }
        };
    }

    public void shutdown() throws Exception {
    }

    public boolean supportHotDeployment() {
        return true;
    }

    public boolean isAvailable() {
        try {
            HttpURLConnection.setFollowRedirects(false);
            HttpURLConnection con = (HttpURLConnection)this.baseURL.openConnection();
            con.setRequestMethod("HEAD");
            return con.getResponseCode() == 200;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("failed to check if tomcat is available");
            return false;
        }
    }
}

