/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.vremodeler.db;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.TableUtils;
import java.sql.SQLException;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.vremodeler.db.DBInterface;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.Collection;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.FunctionalityPersisted;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.GenericResource;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.Ghn;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.RunningInstance;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.RuntimeResource;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.Service;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.VRE;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.VreCollectionRelation;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.VreFunctionalityRelation;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.VreGhnRelation;

public class IStoDBUtil {
    private static GCUBELog logger = new GCUBELog(IStoDBUtil.class);

    private static void createTables(GCUBEScope scope) throws GCUBEFault {
        try {
            ConnectionSource connectionSource = DBInterface.connect();
            TableUtils.createTableIfNotExists((ConnectionSource)connectionSource, RunningInstance.class);
            TableUtils.createTableIfNotExists((ConnectionSource)connectionSource, Ghn.class);
            TableUtils.createTableIfNotExists((ConnectionSource)connectionSource, Collection.class);
            TableUtils.createTableIfNotExists((ConnectionSource)connectionSource, GenericResource.class);
            TableUtils.createTableIfNotExists((ConnectionSource)connectionSource, Service.class);
            TableUtils.createTableIfNotExists((ConnectionSource)connectionSource, RuntimeResource.class);
            TableUtils.createTableIfNotExists((ConnectionSource)connectionSource, FunctionalityPersisted.class);
        }
        catch (Exception e) {
            logger.error((Object)"error creating tables", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
    }

    private static void createRelationTable(GCUBEScope scope) throws GCUBEFault {
        boolean tablesNotCreated = false;
        ConnectionSource connectionSource = null;
        try {
            connectionSource = DBInterface.connect();
            Dao vreDao = DaoManager.createDao((ConnectionSource)connectionSource, VRE.class);
            vreDao.countOf();
        }
        catch (Exception e) {
            logger.trace((Object)"the table doesn't exist");
            tablesNotCreated = true;
        }
        if (tablesNotCreated) {
            try {
                TableUtils.createTableIfNotExists((ConnectionSource)connectionSource, VRE.class);
                TableUtils.createTableIfNotExists((ConnectionSource)connectionSource, VreGhnRelation.class);
                TableUtils.createTableIfNotExists((ConnectionSource)connectionSource, VreCollectionRelation.class);
                TableUtils.createTableIfNotExists((ConnectionSource)connectionSource, VreFunctionalityRelation.class);
            }
            catch (Exception e) {
                logger.error((Object)"error creating relation tables", (Throwable)e);
                throw new GCUBEFault((Throwable)e, new String[0]);
            }
        }
    }

    public static void initDB(GCUBEScope scope) throws GCUBEFault {
        logger.info((Object)("Starting initialization!! the database already exists? " + DBInterface.dbAlreadyCreated(scope)));
        if (DBInterface.dbAlreadyCreated(scope)) {
            IStoDBUtil.cleanDB(scope);
        }
        try {
            IStoDBUtil.createRelationTable(scope);
        }
        catch (Exception e) {
            logger.trace((Object)"table vre already created");
        }
        IStoDBUtil.createTables(scope);
    }

    private static void cleanDB(GCUBEScope scope) throws GCUBEFault {
        try {
            ConnectionSource connectionSource = DBInterface.connect();
            TableUtils.dropTable((ConnectionSource)connectionSource, Ghn.class, (boolean)true);
            TableUtils.dropTable((ConnectionSource)connectionSource, RunningInstance.class, (boolean)true);
            TableUtils.dropTable((ConnectionSource)connectionSource, Collection.class, (boolean)true);
            TableUtils.dropTable((ConnectionSource)connectionSource, GenericResource.class, (boolean)true);
            TableUtils.dropTable((ConnectionSource)connectionSource, RuntimeResource.class, (boolean)true);
            TableUtils.dropTable((ConnectionSource)connectionSource, Service.class, (boolean)true);
            TableUtils.dropTable((ConnectionSource)connectionSource, FunctionalityPersisted.class, (boolean)true);
        }
        catch (SQLException e) {
            logger.error((Object)"error cleaning sqlDB", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
    }
}

