/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.vremodeler.resources;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.Where;
import com.j256.ormlite.support.ConnectionSource;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.vremodeler.db.DBInterface;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.GenericResource;
import org.gcube.vremanagement.vremodeler.resources.ResourceDefinition;
import org.xml.sax.InputSource;

public class GenericResources
extends ResourceDefinition<GenericResource> {
    private static final long serialVersionUID = 1L;
    private static GCUBELog logger = new GCUBELog(GenericResources.class);
    private static Dao<GenericResource, String> grDao;
    private String name = null;
    private String secondaryType = null;
    private String xpathToVerify = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getXpathToVerify() {
        return this.xpathToVerify;
    }

    public void setXpathToVerify(String xpathToVerify) {
        this.xpathToVerify = xpathToVerify;
    }

    public String getSecondaryType() {
        return this.secondaryType;
    }

    public void setSecondaryType(String secondaryType) {
        this.secondaryType = secondaryType;
    }

    @Override
    public List<GenericResource> getResources() throws Exception {
        grDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), GenericResource.class);
        QueryBuilder query = grDao.queryBuilder();
        Where where = query.where().eq("type", (Object)this.getSecondaryType());
        if (this.getName() != null) {
            where.and().eq("name", (Object)this.getName());
        }
        if (this.xpathToVerify != null) {
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression expr = xpath.compile(this.getXpathToVerify());
            logger.trace((Object)("xpath is to verify " + this.xpathToVerify));
            ArrayList<GenericResource> resources = new ArrayList<GenericResource>();
            for (GenericResource genericResource : grDao.query(query.prepare())) {
                if (genericResource.getBody() == null || !((Boolean)expr.evaluate(new InputSource(new StringReader(genericResource.getBody())), XPathConstants.BOOLEAN)).booleanValue()) continue;
                resources.add(genericResource);
            }
            return resources;
        }
        return grDao.query(query.prepare());
    }
}

