/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.vremodeler.resources.handlers;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.support.ConnectionSource;
import java.util.ArrayList;
import java.util.List;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericResourceQuery;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.vremanagement.vremodeler.db.DBInterface;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.GenericResource;
import org.gcube.vremanagement.vremodeler.resources.handlers.ResourceHandler;

public class GenericResourceHandler
implements ResourceHandler<GenericResource> {
    public static GCUBELog logger = new GCUBELog(GenericResourceHandler.class);

    @Override
    public void add(GenericResource resource) throws Exception {
        Dao genericResourceDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), GenericResource.class);
        genericResourceDao.createOrUpdate((Object)resource);
    }

    @Override
    public void drop(String resourceId) throws Exception {
        Dao genericResourceDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), GenericResource.class);
        genericResourceDao.deleteById((Object)resourceId);
    }

    @Override
    public List<GenericResource> initialize() throws Exception {
        ISClient queryClient = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBEGenericResourceQuery query = (GCUBEGenericResourceQuery)queryClient.getQuery(GCUBEGenericResourceQuery.class);
        List gcubeGenericResourcesList = queryClient.execute((ISQuery)query, GCUBEScope.getScope((String)ScopeProvider.instance.get()));
        ArrayList<GenericResource> genericResources = new ArrayList<GenericResource>();
        for (GCUBEGenericResource gcubeGenericResource : gcubeGenericResourcesList) {
            GenericResource genericResource = new GenericResource(gcubeGenericResource.getID(), gcubeGenericResource.getSecondaryType(), gcubeGenericResource.getName(), gcubeGenericResource.getDescription(), gcubeGenericResource.getBody());
            logger.trace((Object)("add genericResource with secondaryType " + genericResource.getType()));
            this.add(genericResource);
            genericResources.add(genericResource);
        }
        return genericResources;
    }
}

