/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.whnmanager.utils;

import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.ResourceMediator;
import org.gcube.common.resources.gcore.ScopeGroup;
import org.gcube.common.scope.impl.ScopeBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ValidationUtils {
    private static final Logger log = LoggerFactory.getLogger(ValidationUtils.class);

    public static void valid(String name, Object object) {
        if (object == null) {
            throw new IllegalArgumentException(String.valueOf(name) + " is null");
        }
    }

    public static <R extends Resource> boolean isPresent(R resource, String currentScope) {
        ScopeGroup scopes = resource.scopes();
        boolean founded = false;
        for (String scope : scopes) {
            if (!scope.equals(currentScope)) continue;
            founded = true;
        }
        return founded;
    }

    public static <R extends Resource> boolean isNotPresent(R resource, String currentScope) {
        ScopeGroup scopes = resource.scopes();
        boolean found = false;
        for (String scope : scopes) {
            if (!scope.equals(currentScope)) continue;
            found = true;
        }
        return !found;
    }

    public static <T extends Resource> void addEnclosingScopesOnResource(T resource, String scope) {
        log.trace("add enclosed scopes of " + scope + " to the resource with id: " + resource.id());
        if (new ScopeBean(scope).is(ScopeBean.Type.VRE)) {
            String voScope = new ScopeBean(scope).enclosingScope().toString();
            String infraScope = new ScopeBean(voScope).enclosingScope().toString();
            log.debug("adding " + voScope + " to the resource " + resource.id());
            ResourceMediator.setScope(resource, (String)voScope);
            log.debug("adding " + infraScope + " to the resource " + resource.id());
            ResourceMediator.setScope(resource, (String)infraScope);
        } else if (new ScopeBean(scope).is(ScopeBean.Type.VO)) {
            String infraScope = new ScopeBean(scope).enclosingScope().toString();
            log.debug("adding " + infraScope + " to the resource " + resource.id());
            ResourceMediator.setScope(resource, (String)infraScope);
        }
    }

    public static <T extends Resource> boolean isTheLastScopeOnResource(T resource, String scope) {
        if (resource.scopes().size() == 0) {
            return true;
        }
        if (new ScopeBean(scope).is(ScopeBean.Type.VRE)) {
            return !ValidationUtils.anotherBrotherVREOrVOOnResource(resource, (String)scope);
        }
        if (new ScopeBean(scope).is(ScopeBean.Type.VO)) {
            if (ValidationUtils.anotherSonVREOnResource(resource, (String)scope)) {
                throw new IllegalArgumentException("the resource " + resource.id() + " have another scope defined in the same VO. The VO is  " + scope);
            }
            return true;
        }
        if (ValidationUtils.anotherInfraScopeOnResource(resource, (String)scope)) {
            throw new IllegalArgumentException("the resource " + resource.id() + " have another scope defined in the same INFRA. The INFRA is  " + scope);
        }
        return true;
    }

    public static <T extends Resource> boolean anotherBrotherVREOrVOOnResource(T resource, String scope) {
        if (!new ScopeBean(scope).is(ScopeBean.Type.VRE)) {
            throw new IllegalArgumentException("anotherBrotherVREOrVOOnResource method: the input scope must be a VRE scope");
        }
        String enclosedScope = new ScopeBean(scope).enclosingScope().toString();
        for (String s : resource.scopes()) {
            if (!ValidationUtils.isChildScope((String)enclosedScope, (String)s)) continue;
            return true;
        }
        return false;
    }

    public static <T extends Resource> boolean anotherSonVREOnResource(T resource, String scope) {
        if (!new ScopeBean(scope).is(ScopeBean.Type.VO)) {
            throw new IllegalArgumentException("anotherSonVREOnResource method: the input scope must be a VO scope");
        }
        for (String s : resource.scopes()) {
            if (!ValidationUtils.isChildScope((String)scope, (String)s)) continue;
            return true;
        }
        return false;
    }

    public static boolean isChildScope(String fatherScope, String sonScope) {
        ScopeBean currentEnclosedScope = new ScopeBean(sonScope).enclosingScope();
        if (currentEnclosedScope != null && currentEnclosedScope.toString().equals(fatherScope)) {
            log.debug("check scope" + fatherScope + ": found another son VRE scope " + sonScope);
            return true;
        }
        return false;
    }

    public static <T extends Resource> boolean anotherInfraScopeOnResource(T resource, String scope) {
        if (!new ScopeBean(scope).is(ScopeBean.Type.INFRASTRUCTURE)) {
            throw new IllegalArgumentException("anotherInfraScopeOnResource method: the input scope must be a INFRASTRUCTURE scope");
        }
        String infraScopeFound = null;
        for (String s : resource.scopes()) {
            while (new ScopeBean(s).enclosingScope() != null) {
                s = new ScopeBean(s).enclosingScope().toString();
            }
            infraScopeFound = s;
            if (!infraScopeFound.equals(scope)) continue;
            log.debug("check scope" + scope + ": found another scope on infra " + s);
            return true;
        }
        return false;
    }
}

