/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resources.federation.fhnmanager.impl;

import cz.cesnet.cloud.occi.api.exception.CommunicationException;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.gcube.resources.federation.fhnmanager.api.FHNManager;
import org.gcube.resources.federation.fhnmanager.api.exception.ConnectorException;
import org.gcube.resources.federation.fhnmanager.api.exception.FHNManagerException;
import org.gcube.resources.federation.fhnmanager.api.type.Node;
import org.gcube.resources.federation.fhnmanager.api.type.NodeTemplate;
import org.gcube.resources.federation.fhnmanager.api.type.ResourceReference;
import org.gcube.resources.federation.fhnmanager.api.type.ResourceTemplate;
import org.gcube.resources.federation.fhnmanager.api.type.ServiceProfile;
import org.gcube.resources.federation.fhnmanager.api.type.VMProvider;
import org.gcube.resources.federation.fhnmanager.impl.ConnectorFactory;
import org.gcube.resources.federation.fhnmanager.is.ISProxyInterface;
import org.gcube.resources.federation.fhnmanager.is.ISProxyLocalYaml;
import org.gcube.resources.federation.fhnmanager.utils.NodeHelper;
import org.gcube.vomanagement.occi.FHNConnector;
import org.gcube.vomanagement.occi.datamodel.cloud.OSTemplate;
import org.gcube.vomanagement.occi.datamodel.cloud.VM;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FHNManagerImpl
implements FHNManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(FHNManagerImpl.class);
    private ConnectorFactory connectorFactory = new ConnectorFactory();
    private ISProxyInterface isProxy = new ISProxyLocalYaml();

    public Node createNode(String vmProviderId, String serviceProfileId, String resourceTemplateId) {
        VMProvider vmp = this.isProxy.getVMProviderById(vmProviderId);
        FHNConnector connector = this.connectorFactory.getConnector(vmp);
        try {
            connector.connect();
            NodeTemplate nt = this.isProxy.getNodeTemplate(serviceProfileId, vmProviderId);
            LOGGER.debug("NodeTemplate found: " + nt);
            String osTemplateId = nt.getOsTemplateId();
            LOGGER.debug("OSTemplateId found: " + osTemplateId);
            ResourceTemplate resourceTemplate = connector.getResourceTemplate(new URI(resourceTemplateId));
            LOGGER.debug("ResourceTemplate found: " + nt);
            OSTemplate osTemplate = connector.getOSTemplate(new URI(osTemplateId));
            LOGGER.debug("OSTemplate found: " + nt);
            ServiceProfile sp = this.isProxy.getServiceProfileById(serviceProfileId);
            URI vmId = connector.createVM("test", osTemplate, resourceTemplate, nt.getScript());
            VM vm = connector.getVM(vmId);
            Node node = NodeHelper.createNode((VM)vm, (VMProvider)vmp, (ServiceProfile)sp, (NodeTemplate)nt, (ResourceTemplate)resourceTemplate);
            this.isProxy.addNode(node);
            return node;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Set<Node> findNodes(String serviceProfileId, String vmProviderId) {
        try {
            this.isProxy.updateIs();
        }
        catch (CommunicationException e) {
            e.printStackTrace();
        }
        return this.isProxy.findNodes(serviceProfileId, vmProviderId);
    }

    public Set<VMProvider> findVMProviders(String serviceProfileId) throws FHNManagerException {
        return this.isProxy.findVMProvidersbyServiceProfile(serviceProfileId);
    }

    public VMProvider getVMProviderbyId(String vmProviderid) {
        return this.isProxy.findVMProviderbyId(vmProviderid);
    }

    public Set<ServiceProfile> allServiceProfiles() throws FHNManagerException {
        return this.isProxy.getAllServiceProfiles();
    }

    public Collection<ResourceTemplate> findResourceTemplate(String vmProviderid) {
        if (vmProviderid == null) {
            HashSet<ResourceTemplate> listvmp = new HashSet<ResourceTemplate>();
            for (VMProvider vmp2 : this.findVMProviders(null)) {
                listvmp.addAll(this.findResourceTemplate(vmp2.getId()));
            }
            return listvmp;
        }
        VMProvider vmp = this.isProxy.getVMProviderById(vmProviderid);
        FHNConnector connector = this.connectorFactory.getConnector(vmp);
        try {
            connector.connect();
            Collection<ResourceTemplate> list = new HashSet();
            list = connector.listResourceTemplates();
            ResourceReference rr = new ResourceReference(vmProviderid);
            for (ResourceTemplate a : list) {
                a.setVmProvider(rr);
            }
            return list;
        }
        catch (CommunicationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Node getNodeById(String nodeId) {
        return this.isProxy.getNodeById(nodeId);
    }

    public void startNode(String NodeId) throws FHNManagerException {
        String vmProviderId = NodeHelper.getVMProviderId((String)NodeId);
        String vmid = NodeHelper.getVMId((String)NodeId);
        VMProvider vmp = this.isProxy.getVMProviderById(vmProviderId);
        FHNConnector connector = this.connectorFactory.getConnector(vmp);
        try {
            connector.connect();
            connector.startVM(URI.create(vmid));
        }
        catch (CommunicationException e) {
            throw new ConnectorException("Exception received from the connector: " + e.getMessage());
        }
    }

    public void stopNode(String NodeId) throws FHNManagerException {
        String vmProviderId = NodeHelper.getVMProviderId((String)NodeId);
        String vmid = NodeHelper.getVMId((String)NodeId);
        VMProvider vmp = this.isProxy.getVMProviderById(vmProviderId);
        FHNConnector connector = this.connectorFactory.getConnector(vmp);
        try {
            connector.connect();
            connector.stopVM(URI.create(vmid));
        }
        catch (CommunicationException e) {
            throw new ConnectorException("Exception received from the connector: " + e.getMessage());
        }
    }

    public void deleteNode(String NodeId) throws FHNManagerException {
        String vmProviderId = NodeHelper.getVMProviderId((String)NodeId);
        String vmid = NodeHelper.getVMId((String)NodeId);
        Node n = this.isProxy.getNodeById(NodeId);
        VMProvider vmp = this.isProxy.getVMProviderById(vmProviderId);
        FHNConnector connector = this.connectorFactory.getConnector(vmp);
        try {
            connector.connect();
            connector.destroyVM(URI.create(vmid));
            this.isProxy.deleteNode(n);
        }
        catch (CommunicationException e) {
            throw new ConnectorException("Exception received from the connector: " + e.getMessage());
        }
    }
}

