package org.gcube.informationsystem.publisher.utils;

import java.util.Iterator;

import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.ScopeGroup;


public class ValidationUtils {
	
	
	public static void valid(String name, Object object){
		if (object==null)
	          throw new IllegalArgumentException(name+" is null");
	}
	
	public  static < R extends Resource > boolean isPresent(R resource, String currentScope){
		ScopeGroup<String> scopes=resource.scopes();
		boolean founded= false;
		for(Iterator<String> it=scopes.iterator(); it.hasNext();){
			String scope=it.next();
			if(scope.equals(currentScope))
				founded=true;
		}
		if(founded)
			throw new IllegalArgumentException(" scope "+currentScope+" is already present in resource");
		return false;
	}

}
