package org.gcube.informationsystem.publisher;

import org.gcube.common.resources.gcore.Resource;

public interface RegistryPublisher {
	
	/** 
	 * The resource is created in the current scope and it is updated in the other scopes that are presents in the resource
	 * @throws IllegalStateException if the current scope is incompatible with the scope defined in the resource or if the scope is already defined in the resource 
	 * @throws IllegalArgumentException if there are problems to contact the Registry service or the resource is not a valid resource
 	 */
	public <T extends Resource> T create(T resource);
	
	/** 
	 * The resource will be updated on all scopes that are defined in the resource.
	 * If an updating operation fail. It will be repeated with best-effort strategy.
	 * @throws IllegalStateException if the current scope is not defined in the resource. 
	 * @throws IllegalArgumentException if there are problems with the registry service or the resource is not a valid resource
	 */
	public <T extends Resource> T update(T resource);
	
	/**
	 * Remove a resource from the current scope if the current scope is defined in the resource 
	 * @throws IllegalArgumentException if the current scope is not defined in the resource 
	 * @return the resource without the current scope if the remove operation has been successfully completed 
	 */
	public  <T extends Resource> T remove(T resource);

	
}
