package org.gcube.informationsystem.publisher;

import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.ResourceMediator;
import org.gcube.common.resources.gcore.Resource.Type;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.publisher.exception.RegistryNotFoundException;
import org.gcube.informationsystem.publisher.stubs.registry.RegistryStub;
import org.gcube.informationsystem.publisher.stubs.registry.faults.RemoveException;
import org.gcube.informationsystem.publisher.stubs.registry.faults.ResourceDoesNotExistException;
import org.gcube.informationsystem.publisher.utils.RegistryStubs;
/**
 * Wrapper class of RegistryPublisherImpl class that implements the RegistryPublisher interface
 * 
 * @author rcirillo
 *
 */
public class AdvancedPublisher extends AdvancedPublisherCommonUtils implements RegistryPublisher {

	private RegistryPublisher publisher;
	private RegistryStubs registry;

	public AdvancedPublisher(){
		publisher=new RegistryPublisherImpl();
		registry=new RegistryStubs();
	}
	
	public AdvancedPublisher(RegistryPublisher publisher){
		this.publisher=publisher;
		registry=new RegistryStubs();
	}

	@Override
	public <T extends Resource> T create(T resource) {
		return publisher.create(resource);
	}

	@Override
	public <T extends Resource> T update(T resource) {
		return publisher.update(resource);
	}

	@Override
	public <T extends Resource> T remove(T resource) {
		return publisher.remove(resource);
	}
	
//	/**
//	 * Remove the input resource from IS and hence from all scope which the resource is defined
//	 * @throws IllegalArgumentException if there are problems to contact the Registry service 
//	 */
//	public <T extends Resource> T removeFromAllScopes(T resource){
//		RegistryStub stub=null;
//		try{
//			stub=registry.getStubs();
//		}catch(RegistryNotFoundException e){
//			throw new IllegalArgumentException(e.getCause());
//		}
//		try{
//			stub.remove(resource.id(), resource.type().toString());
//		}catch(ResourceDoesNotExistException e){
//			throw new IllegalArgumentException(e.getCause());
//		}catch(RemoveException e){
//			throw new IllegalArgumentException(e.getCause());
//		}
//		ResourceMediator.removeScope(resource, ScopeProvider.instance.get());
//		return resource;
//	}
//
//	/**
//	 * Remove the resource defined by id and type parameters from IS and hence from all scope which the resource is defined
//	 * @throws IllegalArgumentException if there are problems to contact the Registry service 
//	 */
//
//	public void removeFromAllScopes(String id, Type type){
//		RegistryStub stub=null;
//		try{
//			stub=registry.getStubs();
//		}catch(RegistryNotFoundException e){
//			throw new IllegalArgumentException(e.getCause());
//		}
//		try{
//			stub.remove(id, type.toString());
//		}catch(ResourceDoesNotExistException e){
//			throw new IllegalArgumentException(e.getCause());
//		}catch(RemoveException e){
//			throw new IllegalArgumentException(e.getCause());
//		}
//
//	}
}
