/**
 * 
 */
package org.gcube.resourcemanagement.updater;

import java.io.IOException;
import java.util.Properties;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.ServiceEndpoint.AccessPoint;

/**
 * @author Roberto Cirillo (ISTI-CNR) 2018
 *
 */
public class AccessPointUpdater {

	/**
	 * @param args
	 * @throws IOException 
	 */
	public static void main(String[] args) throws IOException {
		for (int i=0; i<args.length;i++) 
			System.out.println("param N." +i + ": " + args[i]);
		
		if((args.length != 5)){
			System.out.println("Usage:");
			System.out.println("\tjava  AccessPointUpdater  scope  Category Name AccessEndpointName file.properties\n\n");
			System.out.println("Example:");
			System.out.println("\tjava  AccessPointUpdater  /gcube DataAnalysis Dataminer dataminer.garr.d4science.org /test/environment.properties \n\n");
			return;
		}
		
		String scope=args[0];
		String category=args[1];
		String name=args[2];
		String accessEndpointName=args[3];
		String filePath=args[4]; 
		Properties props=Utils.loadProperties(filePath);
		ServiceEndpoint resource = Utils.getResource(scope, category, name);
		AccessPoint accesspoint = Utils.getAccessPoint(resource, accessEndpointName);
		if (accesspoint != null){
			fill(props, accesspoint);
			Utils.update(resource);
		}else{
			System.out.println("access point not found");
		}
	}

	private static void fill(Properties props, AccessPoint point) {
		   for(String name : props.stringPropertyNames()) {
	        	  String value = props.getProperty(name);
	        	  System.out.println("Adding "+name+ " "+value);
	        	  point.properties().add(new ServiceEndpoint.Property().nameAndValue(name, value));
		   }
	}
	

}
