/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.updater;

import java.io.IOException;
import java.util.Properties;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.resourcemanagement.updater.Utils;

public class AccessPointUpdater {
    public static void main(String[] args) throws IOException {
        for (int i = 0; i < args.length; ++i) {
            System.out.println("param N." + i + ": " + args[i]);
        }
        if (args.length != 5) {
            System.out.println("Usage:");
            System.out.println("\tjava  AccessPointUpdater  scope  Category Name AccessEndpointName file.properties\n\n");
            System.out.println("Example:");
            System.out.println("\tjava  AccessPointUpdater  /gcube DataAnalysis Dataminer dataminer.garr.d4science.org /test/environment.properties \n\n");
            return;
        }
        String scope = args[0];
        String category = args[1];
        String name = args[2];
        String accessEndpointName = args[3];
        String filePath = args[4];
        Properties props = Utils.loadProperties(filePath);
        ServiceEndpoint resource = Utils.getResource(scope, category, name);
        ServiceEndpoint.AccessPoint accesspoint = Utils.getAccessPoint(resource, accessEndpointName);
        if (accesspoint != null) {
            AccessPointUpdater.fill(props, accesspoint);
            Utils.update((Resource)resource);
        } else {
            System.out.println("access point not found");
        }
    }

    private static void fill(Properties props, ServiceEndpoint.AccessPoint point) {
        for (String name : props.stringPropertyNames()) {
            String value = props.getProperty(name);
            System.out.println("Adding " + name + " " + value);
            point.properties().add((Object)new ServiceEndpoint.Property().nameAndValue(name, value));
        }
    }
}

