/**
 * 
 */
package org.gcube.resourcemanagement.updater;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.ServiceEndpoint.AccessPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Roberto Cirillo (ISTI-CNR) 2018
 * 
 *
 */
public class AccessPointClusterUpdater {

	
	/**
	 * List of all the packages retrieved from system
	 */
	protected static ArrayList <String> instances=new ArrayList<String>();


	private static final String ACCESS_POINT_NAME="GetCapabilities";
	private static final String PROPERTY_NAME="Nodes";
	final static Logger logger = LoggerFactory.getLogger(AccessPointClusterUpdater.class);



	/**
	 * @param args
	 * @throws IOException 
	 */
	public static void main(String[] args) throws Exception {
		
		System.out.println("ACCESS POINT CLUSTER UPDATER CLI");
		for (int i=0; i<args.length;i++) 
			System.out.println("param N." +i + ": " + args[i]);
		
		if((args.length != 6)){
			System.out.println("Usage:");
			System.out.println("\tjava  AccessPointClusterUpdater  scope  Category Name HostedOnField backend /path/to/scripts/script.sh \n\n");
			System.out.println("Example:");
			System.out.println("\tjava  AccessPointClusterUpdater  /gcube DataAnalysis Dataminer dataminer.garr.d4science.org prototypes_ssl /path/to/scripts/script.sh \n\n");
			return;
		}
		
		String scope=args[0];
		String category=args[1];
		String name=args[2];
		String hostedOnField=args[3];
		String backend=args[4];
		String filePath=args[5]; 
		List <ServiceEndpoint> resources = Utils.getResources(scope, category, name);
		if(resources!=null){
			ServiceEndpoint resourceTarget = Utils.getResourceFromHostField(hostedOnField, resources);
			if (Objects.isNull(resourceTarget))
				throw new IllegalArgumentException("Resource not found on IS. Please check the input parameters");
			AccessPoint accesspoint = Utils.getAccessPoint(resourceTarget, ACCESS_POINT_NAME);
			if (accesspoint != null){
				System.out.println("access point found");
				logger.info("access point found");
		//retrieve software to ask to the system from properties file. 
				Process proc=exec(filePath+" "+backend);
				fillAP(accesspoint, formatResults(proc));
				Utils.update(resourceTarget);
			}else {
				logger.error("ACCESS POINT "+ACCESS_POINT_NAME+ " not found on the following resource "+resourceTarget.id());
				System.out.println("ACCESS POINT "+ACCESS_POINT_NAME+ " not found on the following resource "+resourceTarget.id());
			}
//			}
		}else{
			System.out.println("No resource found on scope "+scope+" with category: "+category+" and name: "+name);
		}
	}


/**
 * Ask to the system some software versions and update the AccessPoint
 * This fields are stored in the properties file in a special format: /absolute/path/to/the/software/software=argumentUsedForAskTheVersion 
 *	// e.g. /usr/bin/python=--version	
 * where "/usr/bin/python"is the prop name and "--version" is the prop value
 * @param point: AccessPoint to update with the info retrieved by System
 * @param instances contains shell commands 
 */
	private static AccessPoint fillAP(AccessPoint point, ArrayList <String> instances)  { 
		if(Objects.nonNull(instances)) {
			int number=instances.size();
			System.out.println("\n\t Adding number instances: "+number);
		  	point.properties().add(new ServiceEndpoint.Property().nameAndValue(PROPERTY_NAME, number+""));
		}
		return point;
	}
	
	private static AccessPoint fillAP(AccessPoint point, int totalInstances)  { 
		if(totalInstances>0) {
			System.out.println("\n\t Adding number instances: "+totalInstances);
		  	point.properties().add(new ServiceEndpoint.Property().nameAndValue(PROPERTY_NAME, totalInstances+""));
		}
		else {
			System.out.println("number of instances passed is minor than 1");
		}
		return point;
	}
	/**
	 * Exec a bash shell command
	 * @param command command to exec
	 * @return the external process
	 */
	public static Process exec(String command)  {
		Process process;
		System.out.println("running command: "+command);
		try {
			process = Runtime.getRuntime().exec(new String[] { "/bin/bash", "-c", command });
			return process;
		} catch (IOException e) {
			System.out.println("Something went wrong! "+e.getMessage());
			e.printStackTrace();
		}
		return null;
	}
	
	/**
	 * Print console results
	 * @param process
	 * @throws IOException
	 * @throws InterruptedException
	 */
	public static void printResults(Process process) throws IOException, InterruptedException {
		StringBuilder output = new StringBuilder();
		BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
	    String line = "";
	    while ((line = reader.readLine()) != null) {
	    	output.append(line + "\n");
	    }
	    int exitVal = process.waitFor();
		if (exitVal == 0) {
			System.out.println("exit status Success!");
		} else {
			System.out.println("exit status Failed");
		}
		System.out.println("script output: \n\t "+output);
	}
	
	
	/**
	 * Extract version from process result. Notice that the process output is not the same for any software. 
	 * In this method is treated a special case only the R software
	 * @param process
	 * @param command
	 * @return
	 * @throws IOException
	 * @throws InterruptedException
	 */
	private static int formatResults(Process process) throws IOException, InterruptedException {
		System.out.println("getting out result");
		StringBuilder output = new StringBuilder();
		BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
	    String line = "";
	    int countLines=0;
	    while ((line = reader.readLine()) != null) {
	    	output.append(line + "\n");
	    	countLines++;
	    }
	    System.out.println("output: \n"+output);
	    System.out.println("instances "+countLines);
	    return countLines;
	    
	}
	
	public static ArrayList<String> getInstances() {
		return instances;
	}
}
