/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.datasink;

import gr.uoa.di.madgik.searchlibrary.operatorlibrary.IOHandler;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.datasink.DataSink;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import java.net.URI;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSinkOp {
    private Logger log = LoggerFactory.getLogger((String)DataSinkOp.class.getName());
    private static final long TimeoutDef = 60L;
    private static final TimeUnit TimeUnitDef = TimeUnit.SECONDS;
    private long timeout = 60L;
    private TimeUnit timeUnit = TimeUnitDef;
    protected URI inLocator = null;
    private String outputType;
    private String outputValue;
    private Map<String, String> outputParameters;
    private StatsContainer stats = null;

    public DataSinkOp(URI uri, String outputType, String outputValue, Map<String, String> outputParameters, StatsContainer stats) {
        this.inLocator = uri;
        this.outputType = outputType;
        this.outputValue = outputValue;
        this.outputParameters = outputParameters;
        this.stats = stats;
    }

    public DataSinkOp(URI uri, String outputType, String outputValue, HashMap<String, String> outputParameters, StatsContainer stats) {
        this(uri, outputType, outputValue, (Map<String, String>)outputParameters, stats);
    }

    public DataSinkOp(URI uri, String outputType, String outputValue, Map<String, String> outputParameters, long timeout, TimeUnit timeUnit, StatsContainer stats) {
        this(uri, outputType, outputValue, outputParameters, stats);
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    public DataSinkOp(URI uri, String outputType, String outputValue, HashMap<String, String> outputParameters, long timeout, TimeUnit timeUnit, StatsContainer stats) {
        this(uri, outputType, outputValue, (Map<String, String>)outputParameters, timeout, timeUnit, stats);
    }

    public String compute() throws Exception {
        try {
            long start = Calendar.getInstance().getTimeInMillis();
            IOHandler.init(null);
            DataSink dataSink = IOHandler.getDataSink(this.inLocator, this.outputType, this.outputValue, this.outputParameters, this.stats);
            dataSink.setTimeout(this.timeout);
            dataSink.setTimeUnit(this.timeUnit);
            dataSink.start();
            this.stats.timeToInitialize(Calendar.getInstance().getTimeInMillis() - start);
            return dataSink.getOutput();
        }
        catch (Exception e) {
            this.log.error("Could not initialize datasink operation. Throwing Exception", (Throwable)e);
            throw new Exception("Could not initialize datasink operation", e);
        }
    }
}

