/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.datasource;

import gr.uoa.di.madgik.searchlibrary.operatorlibrary.IOHandler;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.datasource.DataSource;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceOp {
    private Logger log = LoggerFactory.getLogger((String)DataSourceOp.class.getName());
    private static final long TimeoutDef = 60L;
    private static final TimeUnit TimeUnitDef = TimeUnit.SECONDS;
    private long timeout = 60L;
    private TimeUnit timeUnit = TimeUnitDef;
    private String inputType;
    private String inputValue;
    private Map<String, String> inputParameters;

    public DataSourceOp(String inputType, String inputValue, Map<String, String> inputParameters) {
        this.inputType = inputType;
        this.inputValue = inputValue;
        this.inputParameters = inputParameters;
    }

    public DataSourceOp(String inputType, String inputValue, HashMap<String, String> inputParameters) {
        this(inputType, inputValue, (Map<String, String>)inputParameters);
    }

    public DataSourceOp(String inputType, String inputValue, Map<String, String> inputParameters, long timeout, TimeUnit timeUnit) {
        this(inputType, inputValue, inputParameters);
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    public DataSourceOp(String inputType, String inputValue, HashMap<String, String> inputParameters, long timeout, TimeUnit timeUnit) {
        this(inputType, inputValue, (Map<String, String>)inputParameters, timeout, timeUnit);
    }

    public URI compute() throws Exception {
        try {
            IOHandler.init(null);
            DataSource dataSource = IOHandler.getDataSource(this.inputType, this.inputValue, this.inputParameters);
            dataSource.setTimeout(this.timeout);
            dataSource.setTimeUnit(this.timeUnit);
            dataSource.start();
            return dataSource.getLocator();
        }
        catch (Exception e) {
            this.log.error("Could not initialize datasource operation. Throwing Exception", (Throwable)e);
            throw new Exception("Could not initialize datasource operation");
        }
    }
}

