/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.test.samplegenerator;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.writer.IRecordWriter;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.sort.OfflineSortWorker;
import java.net.URI;
import java.util.Calendar;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleGeneratorWorker
extends Thread {
    private static Logger logger = LoggerFactory.getLogger((String)OfflineSortWorker.class.getName());
    private IRecordWriter<GenericRecord> writer = null;
    private URI outLocator = null;
    private long timeout = 0L;
    private TimeUnit timeUnit = null;
    private int tableID = 0;
    private Object synchWriter = null;

    public SampleGeneratorWorker(int tableID, Object synchWriter) throws Exception {
        this.tableID = tableID;
        this.writer = new RecordWriter((IWriterProxy)new LocalWriterProxy(), new RecordDefinition[]{new GenericRecordDefinition()}, 100, RecordWriter.DefaultConcurrentPartialCapacity, RecordWriter.DefaultMirrorBufferFactor);
        this.outLocator = this.writer.getLocator();
        this.synchWriter = synchWriter;
    }

    public URI getLocator() {
        return this.outLocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String[] lastNames = new String[]{"Rafferty", "Jones", "Steinberg", "Robinson", "Smith", "John"};
        String[][] departmentID = new String[][]{{"31", "33", "33", "34", "34", null}, {"31", "33", "34", "35"}};
        String[] departmentName = new String[]{"Sales", "Engineering", "Clerical", "Marketing"};
        Random rnd = new Random(97L);
        int rc = 0;
        long now = Calendar.getInstance().getTimeInMillis();
        Object object = this.synchWriter;
        synchronized (object) {
            this.synchWriter.notify();
        }
        try {
            int len = this.tableID == 0 ? lastNames.length : departmentID[1].length;
            for (int i = 0; i < len; ++i) {
                StringBuilder record = new StringBuilder();
                record.append("<record>");
                if (this.tableID == 0) {
                    record.append("<LastName>" + lastNames[i] + "</LastName>");
                    record.append("<DepartmentID>" + departmentID[0][i] + "</DepartmentID>");
                } else {
                    record.append("<DepartmentID>" + departmentID[1][i] + "</DepartmentID>");
                    record.append("<DepartmentName>" + departmentName[i] + "</DepartmentName>");
                }
                record.append("</record>");
                GenericRecord outRec = new GenericRecord();
                StringField outField = new StringField();
                outField.setPayload(record.toString());
                outRec.setFields(new Field[]{outField});
                if (this.writer.getStatus() == IBuffer.Status.Close || this.writer.getStatus() == IBuffer.Status.Dispose) {
                    logger.info("Consumer side stopped consumption. Sample generator stopping prematurely");
                    System.out.println("Consumer side stopped consumption. Sample generator stopping prematurely");
                    break;
                }
                if (this.writer.put((Record)outRec, this.timeout, this.timeUnit)) continue;
                if (this.writer.getStatus() == IBuffer.Status.Open) {
                    logger.warn("Could not write record " + rc + ". Skipping. Available Records = " + this.writer.availableRecords());
                    ++rc;
                    continue;
                }
                System.out.println("Consumer side stopped consumption. Sample generator stopping prematurely");
                break;
            }
            logger.info("Data generation took " + (Calendar.getInstance().getTimeInMillis() - now));
        }
        catch (Exception e) {
            logger.error("Error while generating sample", (Throwable)e);
        }
        finally {
            try {
                this.writer.close();
            }
            catch (Exception e) {}
        }
    }
}

