/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.except;

import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.reader.IRecordReader;
import gr.uoa.di.madgik.grs.reader.decorators.keepalive.KeepAliveReader;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.writer.IRecordWriter;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.except.ExceptWorker;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import java.net.URI;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptOp {
    private static Logger logger = LoggerFactory.getLogger((String)ExceptOp.class.getName());
    private URI leftLocator = null;
    private URI rightLocator = null;
    private static long TimeoutDef = 60L;
    private static TimeUnit TimeUnitDef = TimeUnit.SECONDS;
    private long timeout = TimeoutDef;
    private TimeUnit timeUnit = TimeUnitDef;
    private StatsContainer stats;

    public ExceptOp(URI leftLocator, URI rightLocator, StatsContainer stats) {
        this.leftLocator = leftLocator;
        this.rightLocator = rightLocator;
        this.stats = stats;
    }

    public ExceptOp(URI leftLocator, URI rightLocator, long timeout, TimeUnit timeUnit, StatsContainer stats) {
        this.leftLocator = leftLocator;
        this.rightLocator = rightLocator;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        this.stats = stats;
    }

    public URI compute(String leftKeyFieldName, String rightKeyFieldName) throws Exception {
        try {
            long start = Calendar.getInstance().getTimeInMillis();
            KeepAliveReader reader1 = new KeepAliveReader((IRecordReader)new ForwardReader(this.leftLocator), 1L, TimeUnit.MINUTES);
            ForwardReader reader2 = new ForwardReader(this.rightLocator);
            RecordWriter writer = new RecordWriter((IWriterProxy)new LocalWriterProxy(), (IRecordReader)reader1, 100, RecordWriter.DefaultConcurrentPartialCapacity, RecordWriter.DefaultMirrorBufferFactor);
            this.stats.timeToInitialize(Calendar.getInstance().getTimeInMillis() - start);
            ExceptWorker worker = new ExceptWorker((IRecordWriter<Record>)writer, (IRecordReader<Record>)reader1, (IRecordReader<Record>)reader2, leftKeyFieldName, rightKeyFieldName, this.timeout, this.timeUnit, this.stats);
            worker.start();
            return writer.getLocator();
        }
        catch (Exception e) {
            logger.error("Could not initialize join operation. Throwing Exception", (Throwable)e);
            throw new Exception("Could not initialize join operation");
        }
    }
}

