/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.comparator;

import gr.uoa.di.madgik.searchlibrary.operatorlibrary.comparator.ComparisonMode;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.comparator.InvalidTokenFormatComparison;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;

public class CompareTokens {
    public static final short COMPARE_EQUAL = 0;
    public static final short COMPARE_GREATER = 1;
    public static final short COMPARE_LOWER = -1;
    public static final short ASCENDING_ORDER = 0;
    public static final short DESCENDING_ORDER = 1;
    private static ComparisonMode mode = null;

    private static boolean isNumeric(String alphanum) {
        int i = 0;
        boolean dotFound = false;
        boolean isNumeric = true;
        if (alphanum.length() == 0) {
            return false;
        }
        int start = 0;
        if (alphanum.charAt(0) == '-' || alphanum.charAt(0) == '+') {
            ++start;
        }
        for (i = start; i < alphanum.length(); ++i) {
            if (Character.isDigit(alphanum.charAt(i))) continue;
            if (alphanum.charAt(i) == '.' && !dotFound) {
                dotFound = true;
                continue;
            }
            isNumeric = false;
            break;
        }
        return isNumeric;
    }

    private static boolean isInteger(String num) {
        return CompareTokens.isNumeric(num) && num.indexOf(46) == -1;
    }

    private static boolean isDate(String dateStr) {
        DateFormat df = DateFormat.getDateInstance(3, Locale.US);
        try {
            df.parse(dateStr);
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    public static Date Str2Date(String dateStr) throws ParseException {
        DateFormat df = DateFormat.getDateInstance(3, Locale.US);
        Date myDate = null;
        try {
            myDate = df.parse(dateStr);
        }
        catch (ParseException e) {
            throw new ParseException(e.toString(), e.getErrorOffset());
        }
        return myDate;
    }

    public static int compare(String token1, String token2) throws InvalidTokenFormatComparison {
        token1 = token1.trim();
        token2 = token2.trim();
        try {
            if (!CompareTokens.isNumeric(token1) && !CompareTokens.isDate(token1)) {
                if (token1.compareToIgnoreCase(token2) > 0) {
                    return 1;
                }
                if (token1.compareToIgnoreCase(token2) < 0) {
                    return -1;
                }
                return 0;
            }
            if (!CompareTokens.isNumeric(token2) && !CompareTokens.isDate(token2)) {
                if (token1.compareToIgnoreCase(token2) > 0) {
                    return 1;
                }
                if (token1.compareToIgnoreCase(token2) < 0) {
                    return -1;
                }
                return 0;
            }
            int compareResult = token1.compareToIgnoreCase(token2);
            if (CompareTokens.isNumeric(token1) != CompareTokens.isNumeric(token2)) {
                throw new InvalidTokenFormatComparison(token1, token2);
            }
            if (CompareTokens.isNumeric(token1)) {
                Long LongToken1 = null;
                Long LongToken2 = null;
                Double DoubleToken1 = null;
                Double DoubleToken2 = null;
                long longtok1 = Long.MAX_VALUE;
                long longtok2 = Long.MAX_VALUE;
                double doubletok1 = Double.NaN;
                double doubletok2 = Double.NaN;
                if (CompareTokens.isInteger(token2)) {
                    LongToken2 = Long.valueOf(token2);
                    longtok2 = LongToken2;
                } else {
                    DoubleToken2 = Double.valueOf(token2);
                    doubletok2 = DoubleToken2;
                }
                if (CompareTokens.isInteger(token1)) {
                    LongToken1 = Long.valueOf(token1);
                    longtok1 = LongToken1;
                    compareResult = LongToken2 == null ? ((double)longtok1 == doubletok2 ? 0 : ((double)longtok1 > doubletok2 ? 1 : -1)) : LongToken1.compareTo(LongToken2);
                } else {
                    DoubleToken1 = Double.valueOf(token1);
                    doubletok1 = DoubleToken1;
                    compareResult = DoubleToken2 == null ? ((double)longtok2 == doubletok1 ? 0 : ((double)longtok2 > doubletok1 ? -1 : 1)) : DoubleToken1.compareTo(DoubleToken2);
                }
            } else if (CompareTokens.isDate(token1) && CompareTokens.isDate(token2)) {
                Date myDate1 = null;
                Date myDate2 = null;
                try {
                    myDate1 = CompareTokens.Str2Date(token1);
                    myDate2 = CompareTokens.Str2Date(token2);
                }
                catch (ParseException e) {
                    throw new InvalidTokenFormatComparison("Unexpected ParseError in Date parsing\n" + e.toString());
                }
                compareResult = myDate1.compareTo(myDate2);
            } else {
                compareResult = token1.compareTo(token2);
            }
            if (compareResult < 0) {
                compareResult = -1;
            } else if (compareResult > 0) {
                compareResult = 1;
            }
            return compareResult;
        }
        catch (Exception e) {
            try {
                if (token1.compareToIgnoreCase(token2) < 0) {
                    return -1;
                }
                if (token1.compareToIgnoreCase(token2) > 0) {
                    return 1;
                }
                return 0;
            }
            catch (Exception ee) {
                throw new InvalidTokenFormatComparison();
            }
        }
    }

    public static ComparisonMode getMode(String token1, String token2) throws InvalidTokenFormatComparison {
        if (token1 == null || token2 == null) {
            return ComparisonMode.COMPARE_STRINGS;
        }
        token1 = token1.trim();
        token2 = token2.trim();
        if (!CompareTokens.isNumeric(token1) && !CompareTokens.isDate(token1) || !CompareTokens.isNumeric(token2) && !CompareTokens.isDate(token2)) {
            return ComparisonMode.COMPARE_STRINGS;
        }
        if (CompareTokens.isNumeric(token1) != CompareTokens.isNumeric(token2)) {
            throw new InvalidTokenFormatComparison(token1, token2);
        }
        if (CompareTokens.isDate(token1) && CompareTokens.isDate(token2)) {
            return ComparisonMode.COMPARE_DATES;
        }
        if (CompareTokens.isNumeric(token1)) {
            if (CompareTokens.isInteger(token1)) {
                if (CompareTokens.isInteger(token2)) {
                    return ComparisonMode.COMPARE_LONGINTS;
                }
                return ComparisonMode.COMPARE_LONGINT_DOUBLE;
            }
            if (CompareTokens.isInteger(token2)) {
                return ComparisonMode.COMPARE_DOUBLE_LONGINT;
            }
            if (CompareTokens.isNumeric(token2)) {
                return ComparisonMode.COMPARE_DOUBLES;
            }
        }
        return ComparisonMode.COMPARE_STRINGS;
    }

    public static ComparisonMode getMode() throws Exception {
        if (mode == null) {
            throw new Exception("Mode not set");
        }
        return mode;
    }

    public static void setMode(ComparisonMode mode) {
        CompareTokens.mode = mode;
    }

    public static ComparisonMode updateMode(String token) throws InvalidTokenFormatComparison {
        if (mode == null) {
            if (CompareTokens.isDate(token)) {
                mode = ComparisonMode.COMPARE_DATES;
                return mode;
            }
            if (CompareTokens.isNumeric(token)) {
                if (CompareTokens.isInteger(token)) {
                    mode = ComparisonMode.COMPARE_LONGINTS;
                    return mode;
                }
                mode = ComparisonMode.COMPARE_DOUBLES;
                return mode;
            }
            mode = ComparisonMode.COMPARE_STRINGS;
            return mode;
        }
        switch (mode) {
            case COMPARE_STRINGS: {
                return mode;
            }
            case COMPARE_DATES: {
                if (!CompareTokens.isDate(token)) {
                    mode = ComparisonMode.COMPARE_STRINGS;
                    return mode;
                }
                return mode;
            }
            case COMPARE_LONGINTS: {
                if (CompareTokens.isNumeric(token)) {
                    if (!CompareTokens.isInteger(token)) {
                        mode = ComparisonMode.COMPARE_DOUBLES;
                        return mode;
                    }
                    return mode;
                }
                mode = ComparisonMode.COMPARE_STRINGS;
                return mode;
            }
            case COMPARE_DOUBLES: {
                if (!CompareTokens.isNumeric(token)) {
                    mode = ComparisonMode.COMPARE_STRINGS;
                    return mode;
                }
                return mode;
            }
        }
        mode = ComparisonMode.COMPARE_STRINGS;
        return mode;
    }

    public static int compare(String token1, String token2, ComparisonMode mode) throws InvalidTokenFormatComparison {
        token1 = token1.trim();
        token2 = token2.trim();
        switch (mode) {
            case COMPARE_LONGINTS: {
                try {
                    long longtok1 = Long.parseLong(token1);
                    long longtok2 = Long.parseLong(token2);
                    if (longtok1 == longtok2) {
                        return 0;
                    }
                    if (longtok1 < longtok2) {
                        return -1;
                    }
                    return 1;
                }
                catch (Exception e) {
                    throw new InvalidTokenFormatComparison(token1, token2);
                }
            }
            case COMPARE_LONGINT_DOUBLE: {
                try {
                    long longtok1 = Long.parseLong(token1);
                    double doubletok2 = Double.parseDouble(token2);
                    if ((double)longtok1 == doubletok2) {
                        return 0;
                    }
                    if ((double)longtok1 < doubletok2) {
                        return -1;
                    }
                    return 1;
                }
                catch (NumberFormatException e) {
                    throw new InvalidTokenFormatComparison(token1, token2);
                }
            }
            case COMPARE_DOUBLE_LONGINT: {
                try {
                    double doubletok1 = Double.parseDouble(token1);
                    long longtok2 = Long.parseLong(token2);
                    if (doubletok1 == (double)longtok2) {
                        return 0;
                    }
                    if (doubletok1 < (double)longtok2) {
                        return -1;
                    }
                    return 1;
                }
                catch (NumberFormatException e) {
                    throw new InvalidTokenFormatComparison(token1, token2);
                }
            }
            case COMPARE_DOUBLES: {
                try {
                    double doubletok1 = Double.parseDouble(token1);
                    double doubletok2 = Double.parseDouble(token2);
                    if (doubletok1 == doubletok2) {
                        return 0;
                    }
                    if (doubletok1 < doubletok2) {
                        return -1;
                    }
                    return 1;
                }
                catch (NumberFormatException e) {
                    throw new InvalidTokenFormatComparison(token1, token2);
                }
            }
            case COMPARE_STRINGS: {
                int compareResult = token1.compareToIgnoreCase(token2);
                if (compareResult > 0) {
                    return 1;
                }
                if (compareResult < 0) {
                    return -1;
                }
                return 0;
            }
            case COMPARE_DATES: {
                Date Date1 = null;
                Date Date2 = null;
                try {
                    Date1 = CompareTokens.Str2Date(token1);
                    Date2 = CompareTokens.Str2Date(token2);
                }
                catch (ParseException e) {
                    throw new InvalidTokenFormatComparison("Unexpected ParseError in Date parsing\n" + e.toString());
                }
                int compareResult = Date1.compareTo(Date2);
                if (compareResult < 0) {
                    return -1;
                }
                if (compareResult > 0) {
                    return 1;
                }
                return 0;
            }
        }
        throw new InvalidTokenFormatComparison(token1, token2);
    }
}

