/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.join;

import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.events.KeyValueEvent;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.writer.IRecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.join.EventEntry;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventHandler<T extends Record> {
    private static Logger logger = LoggerFactory.getLogger((String)EventHandler.class.getName());
    public static final int SafeNumberOfResultsDef = 100;
    public static final int JoinRatioComputationStepDef = 100;
    private IRecordWriter<T> writer = null;
    private Queue<EventEntry> eventQueue = null;
    private boolean finalReceivedFromAll = false;
    private boolean[] finalReceived = null;
    private int finalReceivedCount = 0;
    private int finalResultCountValue = 0;
    private int currentResultCountEstimation = 0;
    private int[] currentResultCountFromEvents = null;
    private int currentResultCountMaxFromEvents = 0;
    private int previousResultCountMaxFromEvents = 0;
    private int[] currentResultCountRead = null;
    private int currentResultCountMaxRead = 0;
    private int writerResultCount = 0;
    private Float joinRatio = null;
    private int previousEmissionCheckpoint = 0;
    private int emissionStep = 0;
    private int readerCount;
    boolean emitStoredFinal = false;
    private int safeNumberOfResults = 100;
    private int joinRatioComputationStep = 100;
    private int previousRatioComputationCheckpoint = 0;
    private boolean postFinalEstimationUpdate = false;

    public EventHandler(IRecordWriter<T> writer, Queue<EventEntry> eventQueue, int readerCount, int emissionStep) {
        this.writer = writer;
        this.eventQueue = eventQueue;
        this.readerCount = readerCount;
        this.emissionStep = emissionStep;
        this.finalReceived = new boolean[readerCount];
        this.currentResultCountFromEvents = new int[readerCount];
        this.currentResultCountRead = new int[readerCount];
        this.finalReceivedFromAll = false;
        for (int i = 0; i < readerCount; ++i) {
            this.currentResultCountFromEvents[i] = 0;
            this.currentResultCountRead[i] = 0;
            this.finalReceived[i] = false;
        }
    }

    public EventHandler(IRecordWriter<T> writer, Queue<EventEntry> eventQueue, int readerCount, int emissionStep, int safeNumberOfResults, int joinRatioComputationStep) {
        this(writer, eventQueue, readerCount, emissionStep);
        this.safeNumberOfResults = safeNumberOfResults;
        this.joinRatioComputationStep = joinRatioComputationStep;
    }

    private void setFinalReceived(int id) {
        if (!this.finalReceived[id]) {
            this.finalReceived[id] = true;
            if (++this.finalReceivedCount == this.readerCount) {
                this.finalReceivedFromAll = true;
            }
        }
    }

    private void setAndUpdateCurrentCountEstimation(int id, int count) {
        if (!this.finalReceived[id]) {
            this.currentResultCountFromEvents[id] = count;
            if (this.currentResultCountMaxFromEvents < count) {
                this.currentResultCountMaxFromEvents = count;
            }
        }
    }

    private void setAndUpdateCurrentCount(int id) {
        int n = id;
        this.currentResultCountRead[n] = this.currentResultCountRead[n] + 1;
        if (this.currentResultCountMaxRead < this.currentResultCountRead[id]) {
            this.currentResultCountMaxRead = this.currentResultCountRead[id];
        }
    }

    private void emitEvent(BufferEvent ev) {
        try {
            this.writer.emit(ev);
        }
        catch (Exception e) {
            logger.info("Could not emit event", (Throwable)e);
        }
    }

    private void propagateNonResultEvent(BufferEvent ev) {
        if (ev instanceof KeyValueEvent) {
            if (((KeyValueEvent)ev).getKey().equals("resultsNumber") || ((KeyValueEvent)ev).getKey().equals("resultsNumberFinal")) {
                return;
            }
            this.emitEvent(ev);
        } else {
            this.emitEvent(ev);
        }
    }

    public void propagateEvents() {
        int val;
        if (this.currentResultCountMaxRead > this.safeNumberOfResults && this.writerResultCount > 0 && this.currentResultCountMaxRead - this.previousRatioComputationCheckpoint > this.joinRatioComputationStep) {
            this.previousRatioComputationCheckpoint = this.currentResultCountMaxRead;
            this.joinRatio = Float.valueOf((float)this.writerResultCount / (float)this.currentResultCountMaxRead);
            if (this.finalReceivedFromAll && !this.postFinalEstimationUpdate) {
                this.currentResultCountEstimation = (int)Math.floor(this.joinRatio.floatValue() * (float)this.currentResultCountMaxFromEvents);
                this.emitStoredFinal = true;
                this.postFinalEstimationUpdate = true;
            }
        }
        EventEntry ev = null;
        KeyValueEvent resultEvent = null;
        this.previousResultCountMaxFromEvents = this.currentResultCountMaxFromEvents;
        boolean received = false;
        while ((ev = this.eventQueue.poll()) != null) {
            if (!(ev.event instanceof KeyValueEvent)) {
                this.emitEvent(ev.event);
                continue;
            }
            resultEvent = (KeyValueEvent)ev.event;
            if (resultEvent.getKey().equals("resultsNumberFinal")) {
                this.finalResultCountValue = Integer.parseInt(resultEvent.getValue());
                this.setAndUpdateCurrentCountEstimation(ev.id, this.finalResultCountValue);
                this.setFinalReceived(ev.id);
                if (this.joinRatio != null) {
                    this.currentResultCountEstimation = (int)Math.floor(this.joinRatio.floatValue() * (float)this.currentResultCountMaxFromEvents);
                }
                received = true;
                continue;
            }
            if (resultEvent.getKey().equals("resultsNumber")) {
                val = Integer.parseInt(((KeyValueEvent)ev.event).getValue());
                this.setAndUpdateCurrentCountEstimation(ev.id, val);
                if (this.joinRatio != null) {
                    this.currentResultCountEstimation = (int)Math.floor(this.joinRatio.floatValue() * (float)this.currentResultCountMaxFromEvents);
                }
                received = true;
                continue;
            }
            this.emitEvent(ev.event);
        }
        if (received) {
            val = Math.max(this.writerResultCount, this.currentResultCountEstimation);
            if (val != this.writerResultCount || this.emitStoredFinal) {
                if (this.currentResultCountMaxFromEvents != this.previousResultCountMaxFromEvents) {
                    this.emitEvent((BufferEvent)new KeyValueEvent("resultsNumber", "" + val));
                }
            } else if (this.writerResultCount - this.previousEmissionCheckpoint >= this.emissionStep) {
                this.previousEmissionCheckpoint = this.writerResultCount;
                this.emitEvent((BufferEvent)new KeyValueEvent("resultsNumber", "" + val));
            }
        } else if (this.emitStoredFinal) {
            this.emitEvent((BufferEvent)new KeyValueEvent("resultsNumber", "" + this.currentResultCountEstimation));
            this.emitStoredFinal = false;
        } else if (this.writerResultCount > this.currentResultCountEstimation && this.writerResultCount - this.previousEmissionCheckpoint >= this.emissionStep) {
            this.previousEmissionCheckpoint = this.writerResultCount;
            this.emitEvent((BufferEvent)new KeyValueEvent("resultsNumber", "" + this.writerResultCount));
        }
    }

    public void increaseProducedRecordCount() {
        ++this.writerResultCount;
    }

    public void increaseReadRecordCount(int id) {
        this.setAndUpdateCurrentCount(id);
    }

    public void sendPendingFinalEvents(int count) {
        this.emitEvent((BufferEvent)new KeyValueEvent("resultsNumberFinal", "" + count));
    }
}

