/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.extjdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchQuery {
    private static Logger logger = LoggerFactory.getLogger((String)BatchQuery.class.getName());
    private String driverName;
    private String connectionString;
    private Connection conn;
    private PreparedStatement stmt;
    private int counter = 0;
    private int batchSize;

    public BatchQuery(String driverName, String connectionString, String sql, int recordsPerPart) throws Exception {
        this.driverName = driverName;
        this.connectionString = connectionString;
        this.conn = null;
        this.stmt = null;
        this.batchSize = recordsPerPart;
        try {
            Class.forName(this.driverName).newInstance();
            this.conn = DriverManager.getConnection(this.connectionString);
            this.stmt = this.conn.prepareStatement(sql);
            if (this.conn == null) {
                logger.error("QueryBridge constructor: The connection object is null. Throwing Exception");
                throw new Exception("QueryBridge constructor: The connection object is null");
            }
            if (this.stmt == null) {
                logger.error("QueryBridge constructor: The prepared statement object is null. Throwing Exception");
                throw new Exception("QueryBridge constructor: The prepared statement object is null");
            }
        }
        catch (SQLException e) {
            logger.error("SQLException thrown in QueryBridge constructor. Throwing Exception", (Throwable)e);
            throw new Exception("SQLException thrown in QueryBridge constructor");
        }
        catch (Exception e) {
            logger.error("Exception thrown in QueryBridge constructor. Throwing Exception", (Throwable)e);
            throw new Exception("Exception thrown in QueryBridge constructor");
        }
    }

    public void addBatch(String ... fields) throws Exception {
        try {
            for (int i = 0; i < fields.length; ++i) {
                this.stmt.setString(i + 1, fields[i]);
            }
            this.stmt.addBatch();
            if (++this.counter % this.batchSize == 0) {
                this.stmt.executeBatch();
            }
        }
        catch (Exception e) {
            logger.error("Could not execute Query. Throwing Exception", (Throwable)e);
            throw new Exception("Could not execute Query");
        }
    }

    public void executeBatch() throws SQLException {
        this.stmt.executeBatch();
    }
}

