/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.google;

import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import gr.uoa.di.madgik.grs.writer.IRecordWriter;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.google.QueryGoogleWorker;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import java.net.URI;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleOp {
    private static Logger logger = LoggerFactory.getLogger((String)GoogleOp.class.getName());
    private static StatsContainer stats = null;
    public static String ObjectIdFieldNameDef = "objectId";
    public static String PayloadFieldNameDef = "payload";
    private String objectIdFieldName = ObjectIdFieldNameDef;
    private String payloadFieldName = PayloadFieldNameDef;
    public static final long TimeoutDef = 60L;
    public static final TimeUnit TimeUnitDef = TimeUnit.SECONDS;
    private long timeout = 60L;
    private TimeUnit timeUnit = TimeUnitDef;

    public GoogleOp(StatsContainer stats) {
        GoogleOp.stats = stats;
    }

    public GoogleOp(long timeout, TimeUnit timeUnit, StatsContainer stats) {
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        GoogleOp.stats = stats;
    }

    public GoogleOp(String objectIdFieldName, String payloadFieldName, long timeout, TimeUnit timeUnit, StatsContainer stats) {
        this.objectIdFieldName = objectIdFieldName;
        this.payloadFieldName = payloadFieldName;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        GoogleOp.stats = stats;
    }

    public URI compute(String query, int resNo) throws Exception {
        try {
            long startTime = Calendar.getInstance().getTimeInMillis();
            FieldDefinition[] fieldDefs = new FieldDefinition[]{new StringFieldDefinition(this.objectIdFieldName), new StringFieldDefinition(this.payloadFieldName)};
            RecordWriter writer = new RecordWriter((IWriterProxy)new LocalWriterProxy(), new RecordDefinition[]{new GenericRecordDefinition(fieldDefs)}, 100, RecordWriter.DefaultConcurrentPartialCapacity, RecordWriter.DefaultMirrorBufferFactor);
            QueryGoogleWorker worker = new QueryGoogleWorker(query, resNo, (IRecordWriter<Record>)writer, this.timeout, this.timeUnit, stats);
            stats.timeToInitialize(Calendar.getInstance().getTimeInMillis() - startTime);
            worker.start();
            return writer.getLocator();
        }
        catch (Exception e) {
            logger.error("Could not initialize google operation. Throwing Exception", (Throwable)e);
            throw new Exception("Could not initialize google operation");
        }
    }
}

