/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.merge;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.merge.EventEntry;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.merge.OperationMode;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.merge.Pair;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.merge.ReaderHolder;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.merge.RecordBufferEntry;
import java.util.Queue;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReaderScan
extends Thread {
    private Logger logger = LoggerFactory.getLogger((String)ReaderScan.class.getName());
    private Vector<ReaderHolder> readers = null;
    private BlockingQueue<RecordBufferEntry> buf = null;
    private Queue<EventEntry> events = null;
    private BlockingQueue<Pair<RecordBufferEntry, Integer>> privateBuf = null;
    private long timeout = 0L;
    private TimeUnit timeUnit;
    private int index = 0;
    private String uid = null;
    private OperationMode operationMode;

    public ReaderScan(Vector<ReaderHolder> readers, int index, BlockingQueue<RecordBufferEntry> buf, Queue<EventEntry> events, long timeout, TimeUnit timeUnit, String uid, OperationMode operationMode) {
        this.readers = readers;
        this.index = index;
        this.buf = buf;
        this.events = events;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        this.uid = uid;
        this.operationMode = operationMode;
        if (this.operationMode == OperationMode.Sort) {
            this.privateBuf = new ArrayBlockingQueue<Pair<RecordBufferEntry, Integer>>(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int rc = 0;
        try {
            Vector<ReaderHolder> synchReader;
            this.setName("Reader Scan #" + this.index);
            Object reader = null;
            Vector<ReaderHolder> vector = synchReader = this.readers.get(this.index).getSynchReader();
            synchronized (vector) {
                while (this.readers.get(this.index).getWaitingForInit()) {
                    synchReader.wait();
                }
                reader = this.readers.get(this.index).getReader();
            }
            if (reader == null) {
                this.logger.trace("Reader " + this.index + " of" + this.uid + " is null, returning");
                vector = this.readers;
                synchronized (vector) {
                    this.readers.get(this.index).setFinished(true);
                }
                return;
            }
            while (true) {
                vector = this.readers;
                synchronized (vector) {
                    if (this.readers.get(this.index).hasFinished()) {
                        this.logger.trace("Reader " + this.index + " of " + this.uid + " stopping after being notified");
                        break;
                    }
                }
                if (reader.getStatus() == IBuffer.Status.Dispose || reader.getStatus() == IBuffer.Status.Close && reader.availableRecords() == 0) {
                    this.logger.trace("Reader " + this.index + " of " + this.uid + " stopping, status=" + reader.getStatus());
                    break;
                }
                Record rec = reader.get(this.timeout, this.timeUnit);
                BufferEvent ev = reader.receive();
                if (ev != null) {
                    this.events.add(new EventEntry(ev, this.index));
                }
                if (rec == null) {
                    if (reader.getStatus() == IBuffer.Status.Open) {
                        this.logger.warn("Reader " + this.index + " of " + this.uid + " has timed out");
                    } else {
                        this.logger.trace("Reader " + this.index + " of " + this.uid + " failed to read record and stopped, status=" + reader.getStatus());
                    }
                    break;
                }
                ++rc;
                int rank = -1;
                if (this.operationMode == OperationMode.Sort) {
                    rank = Integer.parseInt(((StringField)rec.getField("rank")).getPayload());
                }
                rec.hide();
                RecordBufferEntry rbe = new RecordBufferEntry(rec, this.index);
                if (this.operationMode == OperationMode.Sort) {
                    this.privateBuf.put(new Pair<RecordBufferEntry, Integer>(rbe, rank));
                    continue;
                }
                this.buf.put(rbe);
            }
        }
        catch (Exception e) {
            this.logger.error("Could not scan entire reader. exiting", (Throwable)e);
        }
        finally {
            this.logger.trace("Reader " + this.index + " of " + this.uid + " produced " + rc + " records");
            Vector<ReaderHolder> vector = this.readers;
            synchronized (vector) {
                this.readers.get(this.index).setFinished(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<RecordBufferEntry, Integer> poll() {
        Vector<ReaderHolder> vector = this.readers;
        synchronized (vector) {
            if (!this.readers.get(this.index).hasFinished()) {
                return (Pair)this.privateBuf.poll();
            }
        }
        return new Pair<RecordBufferEntry, Integer>(new RecordBufferEntry(null, -1), -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<RecordBufferEntry, Integer> peek() {
        Vector<ReaderHolder> vector = this.readers;
        synchronized (vector) {
            if (!this.readers.get(this.index).hasFinished()) {
                return (Pair)this.privateBuf.peek();
            }
        }
        return new Pair<RecordBufferEntry, Integer>(new RecordBufferEntry(null, -1), -1);
    }
}

