/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.select;

import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.writer.IRecordWriter;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.Unary;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.select.SelectWorker;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectOp
extends Unary {
    private Logger logger = LoggerFactory.getLogger((String)SelectOp.class.getName());
    private String logicalExpressions = null;
    private String filterMask;

    public SelectOp(URI inLocator, Map<String, String> operatorParameters, StatsContainer stats) throws Exception {
        super(inLocator, operatorParameters, stats);
        this.logicalExpressions = operatorParameters.get("logicalExpressions");
        this.filterMask = operatorParameters.get("filterMask");
        if (this.logicalExpressions == null && this.filterMask == null) {
            throw new Exception("Initialization failed because both logicalExpression and filterMask parameters are not set");
        }
        this.logger.info("Initialized Select operator with logical Expression: " + this.logicalExpressions + " and filter mask: " + this.filterMask);
    }

    @Override
    public URI compute() throws Exception {
        try {
            RecordDefinition[] recordDefinitionArray;
            long start = Calendar.getInstance().getTimeInMillis();
            ForwardReader reader = new ForwardReader(this.inLocator);
            RecordDefinition[] readerDefs = reader.getRecordDefinitions();
            FieldDefinition[] writerFieldDefs = null;
            Integer[] mask = null;
            if (this.filterMask != null) {
                mask = this.initialiseMask(this.filterMask);
                writerFieldDefs = new FieldDefinition[mask.length];
                for (int i = 0; i < mask.length; ++i) {
                    writerFieldDefs[i] = readerDefs[0].getDefinition(mask[i].intValue());
                }
            }
            LocalWriterProxy localWriterProxy = new LocalWriterProxy();
            if (writerFieldDefs == null) {
                recordDefinitionArray = readerDefs;
            } else {
                RecordDefinition[] recordDefinitionArray2 = new RecordDefinition[1];
                recordDefinitionArray = recordDefinitionArray2;
                recordDefinitionArray2[0] = new GenericRecordDefinition(writerFieldDefs);
            }
            RecordWriter writer = new RecordWriter((IWriterProxy)localWriterProxy, recordDefinitionArray, RecordWriter.DefaultBufferCapacity, RecordWriter.DefaultConcurrentPartialCapacity, RecordWriter.DefaultMirrorBufferFactor);
            SelectWorker worker = new SelectWorker(reader, (IRecordWriter<Record>)writer, this.logicalExpressions, mask, this.stats, this.timeout, this.timeUnit);
            worker.start();
            this.stats.timeToInitialize(Calendar.getInstance().getTimeInMillis() - start);
            return writer.getLocator();
        }
        catch (Exception e) {
            this.logger.error("Could not initialize selection operation. Throwing Exception", (Throwable)e);
            throw new Exception("Could not initialize selection operation", e);
        }
    }

    private Integer[] initialiseMask(String filterMask) {
        ArrayList<Integer> schemaList = new ArrayList<Integer>();
        for (String ref : filterMask.replaceAll("[\\[\\]\\s]", "").split(",")) {
            int index = Integer.parseInt(ref);
            schemaList.add(index);
        }
        return schemaList.toArray(new Integer[schemaList.size()]);
    }
}

