/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.join;

import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.reader.IRecordReader;
import gr.uoa.di.madgik.grs.reader.RandomReader;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.writer.IRecordWriter;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.join.DefinitionIndexResolver;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.join.IndexPair;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.join.JoinWorker;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.join.RecordGenerationPolicy;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.net.URI;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinOp {
    private static Logger logger = LoggerFactory.getLogger((String)JoinOp.class.getName());
    private URI leftLocator = null;
    private URI rightLocator = null;
    public static final RecordGenerationPolicy recordGenerationPolicyDef = RecordGenerationPolicy.Concatenate;
    public static final long TimeoutDef = 180L;
    public static final TimeUnit TimeUnitDef = TimeUnit.SECONDS;
    public static final int BufferCapacityDef = 100;
    private long timeout = 180L;
    private TimeUnit timeUnit = TimeUnitDef;
    private String uid = UUID.randomUUID().toString();
    private RecordGenerationPolicy recordGenerationPolicy = recordGenerationPolicyDef;
    public Map<IndexPair, Integer> producerDefinitionMap = new HashMap<IndexPair, Integer>();
    private StatsContainer stats;
    private int bufferCapacity = 100;

    public JoinOp(URI leftLocator, URI rightLocator, StatsContainer stats) {
        this.leftLocator = leftLocator;
        this.rightLocator = rightLocator;
        this.stats = stats;
    }

    public JoinOp(URI leftLocator, URI rightLocator, RecordGenerationPolicy recordGenerationPolicy, StatsContainer stats) {
        this.leftLocator = leftLocator;
        this.rightLocator = rightLocator;
        this.recordGenerationPolicy = recordGenerationPolicy;
        this.stats = stats;
    }

    public JoinOp(URI leftLocator, URI rightLocator, RecordGenerationPolicy recordGenerationPolicy, long timeout, TimeUnit timeUnit, StatsContainer stats) {
        this.leftLocator = leftLocator;
        this.rightLocator = rightLocator;
        this.recordGenerationPolicy = recordGenerationPolicy;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        this.stats = stats;
    }

    public JoinOp(URI leftLocator, URI rightLocator, RecordGenerationPolicy recordGenerationPolicy, long timeout, TimeUnit timeUnit, int bufferCapacity, StatsContainer stats) {
        this.leftLocator = leftLocator;
        this.rightLocator = rightLocator;
        this.recordGenerationPolicy = recordGenerationPolicy;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        this.bufferCapacity = bufferCapacity;
        this.stats = stats;
    }

    private RecordDefinition[] getProducerRecordDefinitions(String leftKeyFieldName, String rightKeyFieldName, RandomReader<Record> reader1, RandomReader<Record> reader2) throws Exception {
        int i;
        RecordDefinition[] producerRecordDefinitions = null;
        RecordDefinition leftRecordDefinition = null;
        RecordDefinition rightRecordDefinition = null;
        boolean found = false;
        int leftCount = 0;
        int rightCount = 0;
        logger.trace(this.uid + ": Reading record definitions of input readers");
        for (i = 0; i < reader1.getRecordDefinitions().length; ++i) {
            if (reader1.getRecordDefinitions()[i].getDefinition(leftKeyFieldName) == -1) {
                logger.warn(this.uid + ": Could not find a field \"" + leftKeyFieldName + "\" in definition #" + i + " of left reader");
                continue;
            }
            found = true;
            ++leftCount;
        }
        if (!found) {
            logger.warn(this.uid + ": No record definitions containing the join key field " + "\"" + leftKeyFieldName + " were found in the left input");
        }
        found = false;
        for (i = 0; i < reader2.getRecordDefinitions().length; ++i) {
            if (reader2.getRecordDefinitions()[i].getDefinition(rightKeyFieldName) == -1) {
                logger.warn(this.uid + ": Could not find a field \"" + rightKeyFieldName + "\" in definition #" + i + " of right reader");
                continue;
            }
            found = true;
            ++rightCount;
        }
        if (!found) {
            logger.warn(this.uid + ": No record definitions containing the join key field " + "\"" + rightKeyFieldName + " were found in the right input");
            return new RecordDefinition[0];
        }
        producerRecordDefinitions = new RecordDefinition[leftCount * rightCount];
        int producerDef = 0;
        for (int i2 = 0; i2 < reader1.getRecordDefinitions().length; ++i2) {
            if (reader1.getRecordDefinitions()[i2].getDefinition(leftKeyFieldName) == -1) continue;
            for (int j = 0; j < reader2.getRecordDefinitions().length; ++j) {
                ByteArrayOutputStream out;
                int jj;
                if (reader2.getRecordDefinitions()[j].getDefinition(rightKeyFieldName) == -1) continue;
                leftRecordDefinition = reader1.getRecordDefinitions()[i2];
                rightRecordDefinition = reader2.getRecordDefinitions()[j];
                if (!leftRecordDefinition.getClass().equals(rightRecordDefinition.getClass())) {
                    logger.error(this.uid + "Left and right record definition type mismatch");
                    throw new Exception("Left and right record definition type mismatch");
                }
                FieldDefinition[] producerDefFields = new FieldDefinition[leftRecordDefinition.getDefinitionSize() + rightRecordDefinition.getDefinitionSize() - 1];
                int ii = 0;
                for (jj = 0; jj < leftRecordDefinition.getDefinitionSize(); ++jj) {
                    producerDefFields[ii] = (FieldDefinition)Class.forName(leftRecordDefinition.getDefinition(jj).getClass().getName()).newInstance();
                    out = new ByteArrayOutputStream();
                    leftRecordDefinition.getDefinition(jj).deflate((DataOutput)new DataOutputStream(out));
                    producerDefFields[ii++].inflate((DataInput)new DataInputStream(new ByteArrayInputStream(out.toByteArray())));
                }
                for (jj = 0; jj < rightRecordDefinition.getDefinitionSize(); ++jj) {
                    if (rightRecordDefinition.getDefinition(jj).getName().equals(rightKeyFieldName)) continue;
                    producerDefFields[ii] = (FieldDefinition)Class.forName(rightRecordDefinition.getDefinition(jj).getClass().getName()).newInstance();
                    out = new ByteArrayOutputStream();
                    rightRecordDefinition.getDefinition(jj).deflate((DataOutput)new DataOutputStream(out));
                    producerDefFields[ii++].inflate((DataInput)new DataInputStream(new ByteArrayInputStream(out.toByteArray())));
                }
                this.producerDefinitionMap.put(new IndexPair(i2, j), producerDef);
                producerRecordDefinitions[producerDef++] = new GenericRecordDefinition(producerDefFields);
                for (int k = 0; k < producerDefFields.length; ++k) {
                    int cnt = 0;
                    for (int l = 0; l < producerDefFields.length; ++l) {
                        if (k == l || !producerDefFields[k].getName().equals(producerDefFields[l].getName())) continue;
                        producerDefFields[l].setName(producerDefFields[l].getName() + "." + cnt++);
                    }
                }
            }
        }
        return producerRecordDefinitions;
    }

    private int[] getProducerKeyIndices(RecordDefinition[] defs, String keyFieldName) {
        int[] indices = new int[defs.length];
        for (int def = 0; def < defs.length; ++def) {
            for (int i = 0; i < defs[def].getDefinitionSize(); ++i) {
                if (!defs[def].getDefinition(i).getName().equals(keyFieldName)) continue;
                indices[def] = i;
            }
        }
        return indices;
    }

    public URI compute(String leftKeyFieldName, String rightKeyFieldName) throws Exception {
        try {
            long start = Calendar.getInstance().getTimeInMillis();
            logger.trace(this.uid + ": Initializing left input reader with locator " + this.leftLocator);
            RandomReader reader1 = new RandomReader(this.leftLocator, this.bufferCapacity);
            logger.trace(this.uid + ": Initializing right input reader with locator " + this.rightLocator);
            RandomReader reader2 = new RandomReader(this.rightLocator, this.bufferCapacity);
            RecordWriter writer = null;
            RecordDefinition[] producerDef = null;
            if (this.recordGenerationPolicy == RecordGenerationPolicy.Concatenate) {
                producerDef = this.getProducerRecordDefinitions(leftKeyFieldName, rightKeyFieldName, (RandomReader<Record>)reader1, (RandomReader<Record>)reader2);
                writer = new RecordWriter((IWriterProxy)new LocalWriterProxy(), producerDef, this.bufferCapacity, RecordWriter.DefaultConcurrentPartialCapacity, RecordWriter.DefaultMirrorBufferFactor);
            } else if (this.recordGenerationPolicy == RecordGenerationPolicy.KeepLeft) {
                writer = new RecordWriter((IWriterProxy)new LocalWriterProxy(), (IRecordReader)reader1, this.bufferCapacity, RecordWriter.DefaultConcurrentPartialCapacity, RecordWriter.DefaultMirrorBufferFactor);
                producerDef = reader1.getRecordDefinitions();
            } else {
                writer = new RecordWriter((IWriterProxy)new LocalWriterProxy(), (IRecordReader)reader2, this.bufferCapacity, RecordWriter.DefaultConcurrentPartialCapacity, RecordWriter.DefaultMirrorBufferFactor);
                producerDef = reader2.getRecordDefinitions();
            }
            this.stats.timeToInitialize(Calendar.getInstance().getTimeInMillis() - start);
            DefinitionIndexResolver defResolver = new DefinitionIndexResolver(this.recordGenerationPolicy);
            if (this.recordGenerationPolicy.equals((Object)RecordGenerationPolicy.Concatenate)) {
                defResolver.setDefinitionMap(this.producerDefinitionMap);
            }
            JoinWorker worker = new JoinWorker((IRecordWriter<Record>)writer, (RandomReader<Record>)reader1, (RandomReader<Record>)reader2, leftKeyFieldName, rightKeyFieldName, defResolver, this.getProducerKeyIndices(producerDef, leftKeyFieldName), this.recordGenerationPolicy, this.timeout, this.timeUnit, this.stats, this.uid);
            worker.start();
            logger.trace(this.uid + ": Returning " + writer.getLocator());
            return writer.getLocator();
        }
        catch (Exception e) {
            logger.error("Could not initialize join operation " + this.uid + ". Throwing Exception", (Throwable)e);
            throw new Exception("Could not initialize join operation");
        }
    }
}

