/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.transform;

import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.local.LocalWriterProxy;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.reader.IRecordReader;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.writer.IRecordWriter;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.Unary;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.transform.TransformWorker;
import java.net.URI;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformOp
extends Unary {
    private Logger logger = LoggerFactory.getLogger((String)TransformOp.class.getName());
    private String payloadFieldName = null;
    private String xslt;

    public TransformOp(URI inLocator, Map<String, String> operatorParameters, StatsContainer stats) throws Exception {
        super(inLocator, operatorParameters, stats);
        this.payloadFieldName = operatorParameters.get("payloadFieldName");
        this.xslt = operatorParameters.get("xslt");
        if (this.payloadFieldName == null || this.xslt == null) {
            throw new Exception("payload fields name not set in parameters");
        }
    }

    public TransformOp(URI inLocator, Map<String, String> operatorParameters, StatsContainer stats, long timeout, TimeUnit timeUnit) throws Exception {
        super(inLocator, operatorParameters, stats, timeout, timeUnit);
        this.xslt = operatorParameters.get("xslt");
        this.payloadFieldName = operatorParameters.get("payloadFieldName");
        if (this.payloadFieldName == null || this.xslt == null) {
            throw new Exception("payload fields name not set in parameters");
        }
    }

    @Override
    public URI compute() throws Exception {
        try {
            long start = Calendar.getInstance().getTimeInMillis();
            ForwardReader reader = new ForwardReader(this.inLocator);
            RecordWriter writer = new RecordWriter((IWriterProxy)new LocalWriterProxy(), (IRecordReader)reader);
            TransformWorker worker = new TransformWorker(reader, (IRecordWriter<Record>)writer, this.payloadFieldName, this.xslt, this.stats, this.timeout, this.timeUnit);
            worker.start();
            long readerstop = Calendar.getInstance().getTimeInMillis();
            this.stats.timeToInitialize(readerstop - start);
            return writer.getLocator();
        }
        catch (Exception e) {
            this.logger.error("Could not initialize transform operation. Throwing Exception", (Throwable)e);
            throw new Exception("Could not initialize transform operation");
        }
    }
}

