/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.searchlibrary.resultset.elements;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.KeyFactory;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import org.apache.log4j.Logger;
import org.gcube.common.searchservice.searchlibrary.resultset.ResultSet;
import org.gcube.common.searchservice.searchlibrary.resultset.helpers.RSFileHelper;
import sun.misc.BASE64Decoder;

public class StreamWorker
extends Thread {
    private static Logger log = Logger.getLogger(StreamWorker.class);
    private Socket sock;

    public StreamWorker(Socket sock) {
        this.sock = sock;
    }

    @Override
    public void run() {
        InputStream in = null;
        OutputStream out = null;
        DataInputStream din = null;
        FilterOutputStream dout = null;
        try {
            in = this.sock.getInputStream();
            din = new DataInputStream(in);
            int headerSize = din.readInt();
            byte[] header = new byte[headerSize];
            din.readFully(header);
            String headerName = new String(header);
            int keySize = din.readInt();
            byte[] key = new byte[keySize];
            if (keySize > 0) {
                din.readFully(key);
            }
            out = this.sock.getOutputStream();
            dout = new DataOutputStream(out);
            ResultSet rs = null;
            if (keySize > 0) {
                byte[] rawkey = new BASE64Decoder().decodeBuffer(new String(key));
                PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(rawkey);
                KeyFactory factory = KeyFactory.getInstance("RSA");
                RSAPrivateKey pk = (RSAPrivateKey)factory.generatePrivate(spec);
                rs = new ResultSet(headerName, pk);
            } else {
                rs = new ResultSet(headerName);
            }
            try {
                do {
                    try {
                        ((DataOutputStream)dout).writeInt(-1);
                        RSFileHelper.copy(rs, rs.getCurrentContentPartName(), (DataOutputStream)dout);
                    }
                    catch (Exception e) {
                        log.error((Object)"Could not copy current content part. Continuing", (Throwable)e);
                    }
                } while (rs.getNextPart(-1));
            }
            catch (Exception e) {
                log.error((Object)"Could not complete streaming of parts. closing", (Throwable)e);
            }
            rs.clear();
            ((DataOutputStream)dout).writeInt(-2);
        }
        catch (Exception e) {
            log.error((Object)"Could not complete socket transfer. exiting", (Throwable)e);
        }
        try {
            if (din != null) {
                din.close();
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not close data input stream.continuing", (Throwable)e);
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not close input stream.continuing", (Throwable)e);
        }
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not close output stream.continuing", (Throwable)e);
        }
        try {
            if (dout != null) {
                dout.close();
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not close data output stream.continuing", (Throwable)e);
        }
        try {
            this.sock.close();
        }
        catch (Exception e) {
            log.error((Object)"Could not close socket.continuing", (Throwable)e);
        }
    }
}

