/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.searchlibrary.resultset.elements;

import java.util.Vector;
import org.apache.log4j.Logger;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.RecordAttribute;

public abstract class ResultElementBase {
    private static Logger log = Logger.getLogger(ResultElementBase.class);
    private RecordAttribute[] attrs = null;

    public abstract String toXML() throws Exception;

    public abstract void fromXML(String var1) throws Exception;

    public RecordAttribute[] getRecordAttributes() {
        return this.attrs;
    }

    public RecordAttribute[] getRecordAttributes(String attrName) {
        if (this.attrs == null) {
            return new RecordAttribute[0];
        }
        Vector<RecordAttribute> at = new Vector<RecordAttribute>();
        for (int i = 0; i < this.attrs.length; ++i) {
            if (this.attrs[i].getAttrName().compareTo(attrName) != 0) continue;
            at.add(this.attrs[i]);
        }
        return at.toArray(new RecordAttribute[0]);
    }

    public void setRecordAttributes(RecordAttribute[] attrs) {
        this.attrs = attrs;
    }

    public final String RS_toXML() throws Exception {
        String xml = this.toXML();
        StringBuilder validXML = new StringBuilder("<RSRecord");
        if (this.attrs != null && this.attrs.length > 0) {
            for (int i = 0; i < this.attrs.length; ++i) {
                validXML.append(" " + this.attrs[i].getAttrName() + "=\"" + this.attrs[i].getAttrValue() + "\"");
            }
        }
        if (xml == null) {
            validXML.append("/>");
        } else {
            validXML.append(">");
            validXML.append(xml);
            validXML.append("</RSRecord>");
        }
        String recXML = validXML.toString();
        if (!ResultElementBase.valid(recXML)) {
            log.error((Object)"record is not valid. Throwing Exception");
            throw new Exception("record is not valid");
        }
        return recXML;
    }

    public final void RS_fromXML(String xml) throws Exception {
        if (!ResultElementBase.valid(xml)) {
            log.error((Object)"record is not valid. Throwing Exception");
            throw new Exception("record is not valid");
        }
        String payload = null;
        String attrsS = null;
        Vector<RecordAttribute> attrs = new Vector<RecordAttribute>();
        if (xml.endsWith("/>")) {
            payload = null;
            attrsS = xml.substring("<".length() + "RSRecord".length(), xml.length() - "/>".length());
        } else {
            payload = xml.substring(xml.indexOf(">") + ">".length(), xml.lastIndexOf("</RSRecord>"));
            attrsS = "<".length() + "RSRecord".length() <= xml.indexOf(">") - ">".length() ? xml.substring("<".length() + "RSRecord".length(), xml.indexOf(">") - ">".length()) : "";
        }
        String[] attrsSA = attrsS.split("\"");
        try {
            for (int i = 0; i < attrsSA.length - 1; i += 2) {
                try {
                    attrs.add(new RecordAttribute(attrsSA[i].trim().substring(0, attrsSA[i].trim().lastIndexOf("=")), attrsSA[i + 1]));
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setRecordAttributes(attrs.toArray(new RecordAttribute[0]));
        this.fromXML(payload);
    }

    public static final boolean isValid(String xml) {
        return ResultElementBase.valid(xml);
    }

    private static boolean valid(String xml) {
        try {
            return xml.trim().startsWith("<RSRecord") && (xml.trim().endsWith("</RSRecord>") || xml.trim().endsWith("/>"));
        }
        catch (Exception e) {
            return false;
        }
    }
}

