/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.searchlibrary.rsreader;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.KeepTopThreadGeneric;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementBase;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementType;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBase;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.InitReaderThread;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.MakeLocalThreadGeneric;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocationWrapper;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocator;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceLocalType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceWSRFType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.ReaderInitParams;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSReader;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSXMLIterator;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSFullWriter;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSWriterCreationParams;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class RSXMLReader
extends RSReader {
    private static Logger log = Logger.getLogger(RSXMLReader.class);
    RSLocationWrapper rs = null;

    public static RSXMLReader getRSXMLReader(RSLocator locator) throws Exception {
        try {
            return new RSXMLReader(new RSLocationWrapper(locator));
        }
        catch (Exception e) {
            log.error((Object)"Could not create RSXMLReader Throwing Exception", (Throwable)e);
            throw new Exception("Could not create RSXMLReader");
        }
    }

    public static RSXMLReader[] getRSXMLReader(ReaderInitParams[] params) {
        int i;
        InitReaderThread[] ts = new InitReaderThread[params.length];
        RSXMLReader[] rs = new RSXMLReader[params.length];
        for (i = 0; i < params.length; ++i) {
            ts[i] = new InitReaderThread(params[i], InitReaderThread.RSReaderEnum.XMLReader);
            ts[i].start();
        }
        for (i = 0; i < params.length; ++i) {
            try {
                ts[i].join();
                rs[i] = (RSXMLReader)ts[i].getReader();
                continue;
            }
            catch (Exception e) {
                log.error((Object)"interrupted whil waiting for reader. setting to null");
                rs[i] = null;
            }
        }
        return rs;
    }

    protected RSXMLReader(RSLocationWrapper rs) {
        super(rs);
        this.rs = rs;
    }

    public RSXMLIterator getRSIterator() throws Exception {
        try {
            return new RSXMLIterator(RSXMLReader.getRSXMLReader(this.getRSLocator()));
        }
        catch (Exception e) {
            log.error((Object)"could not create iterator. Throwing Exception", (Throwable)e);
            throw new Exception("could not create iterator");
        }
    }

    public RSXMLIterator getRSIterator(int waittime) throws Exception {
        try {
            return new RSXMLIterator(RSXMLReader.getRSXMLReader(this.getRSLocator()), waittime);
        }
        catch (Exception e) {
            log.error((Object)"could not create iterator. Throwing Exception", (Throwable)e);
            throw new Exception("could not create iterator");
        }
    }

    public int getNumberOfResults() throws Exception {
        try {
            return this.rs.getNumberOfResults(PropertyElementType.XML);
        }
        catch (Exception e) {
            log.error((Object)"Could not get number of results. Throwing Exception", (Throwable)e);
            throw new Exception("Could not get number of results");
        }
    }

    public ResultElementBase getResults(Class template, int index) throws Exception {
        try {
            ResultElementBase tmp = (ResultElementBase)template.newInstance();
            tmp.RS_fromXML(this.rs.getResults(index));
            return tmp;
        }
        catch (Exception e) {
            log.error((Object)"Could not get result. Throwing Exception", (Throwable)e);
            throw new Exception("Could not get result");
        }
    }

    public ResultElementBase[] getResults(Class template) throws Exception {
        try {
            String[] res = this.rs.getResults();
            if (res == null || res.length == 0) {
                return new ResultElementBase[0];
            }
            ResultElementBase[] ret = new ResultElementBase[res.length];
            for (int i = 0; i < res.length; ++i) {
                try {
                    ResultElementBase tmp = (ResultElementBase)template.newInstance();
                    tmp.RS_fromXML(res[i]);
                    ret[i] = tmp;
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)"Error while creating result element. Putting null and continuing", (Throwable)e);
                    ret[i] = null;
                }
            }
            return ret;
        }
        catch (Exception e) {
            log.error((Object)"Could not get results. Throwing Exception", (Throwable)e);
            throw new Exception("Could not get results");
        }
    }

    public ResultElementBase[] getResults(Class template, int from, int to) throws Exception {
        try {
            String[] res = this.rs.getResults(from, to);
            if (res == null || res.length == 0) {
                return new ResultElementBase[0];
            }
            ResultElementBase[] ret = new ResultElementBase[res.length];
            for (int i = 0; i < res.length; ++i) {
                try {
                    ResultElementBase tmp = (ResultElementBase)template.newInstance();
                    tmp.RS_fromXML(res[i]);
                    ret[i] = tmp;
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)"Error while creating result element. Putting null and continuing", (Throwable)e);
                    ret[i] = null;
                }
            }
            return ret;
        }
        catch (Exception e) {
            log.error((Object)"Could not get results. Throwing Exception", (Throwable)e);
            throw new Exception("Could not get results");
        }
    }

    public String executeQueryOnDocument(String xPath) throws Exception {
        try {
            return this.rs.executeQueryOnDocument(xPath);
        }
        catch (Exception e) {
            log.error((Object)"Could not execute query. Throwing Exception", (Throwable)e);
            throw new Exception("Could not execute query");
        }
    }

    public ResultElementBase[] filter(Class template, String xPath) throws Exception {
        try {
            String[] res = this.rs.executeQueryOnResults(xPath);
            if (res == null || res.length == 0) {
                return new ResultElementBase[0];
            }
            ResultElementBase[] ret = new ResultElementBase[res.length];
            for (int i = 0; i < res.length; ++i) {
                try {
                    ResultElementBase tmp = (ResultElementBase)template.newInstance();
                    tmp.RS_fromXML(res[i]);
                    ret[i] = tmp;
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)"Error while creating result element. Putting null and continuing", (Throwable)e);
                    ret[i] = null;
                }
            }
            return ret;
        }
        catch (Exception e) {
            log.error((Object)"Could not execute query. Throwing Exception", (Throwable)e);
            throw new Exception("Could not execute query");
        }
    }

    public RSXMLReader filter(String xPath) throws Exception {
        try {
            String headName = this.rs.filterRS(xPath);
            RSLocator newLocator = null;
            newLocator = this.getRSLocator().getRSResourceType() instanceof RSResourceLocalType ? new RSLocator(new RSResourceLocalType(), headName) : this.rs.wrap(new RSResourceWSRFType(), headName, this.getRSLocator().getURI().toString());
            return RSXMLReader.getRSXMLReader(newLocator);
        }
        catch (Exception e) {
            log.error((Object)"Could not filter. Throwing Exception", (Throwable)e);
            throw new Exception("Could not filter");
        }
    }

    public RSXMLReader filter(String xPath, PropertyElementBase[] properties) throws Exception {
        try {
            if (properties == null || properties.length == 0) {
                log.error((Object)"Cannot initialize Result Set with empty property list. Throwing Exception");
                throw new Exception("Cannot initialize Result Set with empty property list");
            }
            String[] props = new String[properties.length];
            for (int i = 0; i < properties.length; ++i) {
                props[i] = properties[i].RS_toXML();
            }
            String headName = this.rs.filterRS(xPath, props);
            RSLocator newLocator = null;
            newLocator = this.getRSLocator().getRSResourceType() instanceof RSResourceLocalType ? new RSLocator(new RSResourceLocalType(), headName) : this.rs.wrap(new RSResourceWSRFType(), headName, this.getRSLocator().getURI().toString());
            return RSXMLReader.getRSXMLReader(newLocator);
        }
        catch (Exception e) {
            log.error((Object)"Could not filter. Throwing Exception", (Throwable)e);
            throw new Exception("Could not filter");
        }
    }

    public String project(String transformation) throws Exception {
        try {
            return this.rs.transformByXSLT(transformation);
        }
        catch (Exception e) {
            log.error((Object)"Could not perform transform and retrieve. Throwing Exception", (Throwable)e);
            throw new Exception("Could not perform transform and retrieve. Throwing Exception");
        }
    }

    public RSXMLReader transform(String transformation) throws Exception {
        try {
            String headName = this.rs.transformRS(transformation);
            RSLocator newLocator = null;
            newLocator = this.getRSLocator().getRSResourceType() instanceof RSResourceLocalType ? new RSLocator(new RSResourceLocalType(), headName) : this.rs.wrap(new RSResourceWSRFType(), headName, this.getRSLocator().getURI().toString());
            return RSXMLReader.getRSXMLReader(newLocator);
        }
        catch (Exception e) {
            log.error((Object)"Could not trasnform. Throwing Exception", (Throwable)e);
            throw new Exception("Could not trasnform");
        }
    }

    public RSXMLReader transformByXSLT(String transformation, PropertyElementBase[] properties) throws Exception {
        try {
            if (properties == null || properties.length == 0) {
                log.error((Object)"Cannot initialize Result Set with empty property list. Throwing Exception");
                throw new Exception("Cannot initialize Result Set with empty property list");
            }
            String[] props = new String[properties.length];
            for (int i = 0; i < properties.length; ++i) {
                props[i] = properties[i].RS_toXML();
            }
            String headName = this.rs.transformRS(transformation, props);
            RSLocator newLocator = null;
            newLocator = this.getRSLocator().getRSResourceType() instanceof RSResourceLocalType ? new RSLocator(new RSResourceLocalType(), headName) : this.rs.wrap(new RSResourceWSRFType(), headName, this.getRSLocator().getURI().toString());
            return RSXMLReader.getRSXMLReader(newLocator);
        }
        catch (Exception e) {
            log.error((Object)"Could not trasnform. Throwing Exception", (Throwable)e);
            throw new Exception("Could not trasnform");
        }
    }

    public RSXMLReader makeLocalPatiently(RSResourceType type, int waittime) throws Exception {
        try {
            if (!(!this.isLocal() || this.rs.isForward() || this.rs.hasAccessLeasing() || this.rs.hasTimeLeasing() || this.rs.isSecure() || this.rs.isScoped())) {
                if (this.rs.getRSLocator().getRSResourceType() instanceof RSResourceLocalType) {
                    return RSXMLReader.getRSXMLReader(this.rs.getRSLocator());
                }
                if (this.rs.getRSLocator().getRSResourceType() instanceof RSResourceWSRFType) {
                    return RSXMLReader.getRSXMLReader(new RSLocator(new RSResourceLocalType(), this.rs.getHeadFileName()));
                }
                log.error((Object)"RSResource type not recognized. Throwing Exception");
                throw new Exception("RSResource type not recognized");
            }
            RSReader thisReader = RSReader.getRSReader(this.getRSLocator());
            String properties = thisReader.retrieveCustomProperties();
            RSFullWriter writer = RSFullWriter.getRSFullWriter(properties);
            if (!(type instanceof RSResourceLocalType) && !(type instanceof RSResourceWSRFType)) {
                log.error((Object)"not regognized resource type.Throwing Exception");
                throw new Exception("not regognized resource type.Throwing Exception");
            }
            MakeLocalThreadGeneric worker = new MakeLocalThreadGeneric(writer, thisReader, MakeLocalThreadGeneric.CLEAR, waittime, this.rs.getStaticPort(), this.rs.getSSLsupport());
            worker.start();
            return RSXMLReader.getRSXMLReader(writer.getRSLocator(type));
        }
        catch (Exception e) {
            log.error((Object)"Could not make local. Throwing Exception", (Throwable)e);
            throw new Exception("Could not make local");
        }
    }

    public String getStringFromDocument(Document doc) {
        try {
            DOMSource domSource = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (TransformerException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public RSXMLReader makeLocalPatiently(RSResourceType type, int waittime, PropertyElementBase[] properties) throws Exception {
        try {
            if (!(!this.isLocal() || this.rs.isForward() || this.rs.hasAccessLeasing() || this.rs.hasTimeLeasing() || this.rs.isSecure() || this.rs.isScoped())) {
                if (this.rs.getRSLocator().getRSResourceType() instanceof RSResourceLocalType) {
                    return RSXMLReader.getRSXMLReader(this.rs.getRSLocator());
                }
                if (this.rs.getRSLocator().getRSResourceType() instanceof RSResourceWSRFType) {
                    return RSXMLReader.getRSXMLReader(new RSLocator(new RSResourceLocalType(), this.rs.getHeadFileName()));
                }
                log.error((Object)"RSResource type not recognized. Throwing Exception");
                throw new Exception("RSResource type not recognized");
            }
            RSReader thisReader = RSReader.getRSReader(this.getRSLocator());
            String customProperties = thisReader.retrieveCustomProperties();
            String allProperties = null;
            try {
                DocumentBuilderFactory datadbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder datadb = datadbf.newDocumentBuilder();
                Document datadom = datadb.parse(new InputSource(new StringReader(customProperties)));
                Element imp = datadom.getDocumentElement();
                for (int i = 0; i < properties.length; ++i) {
                    log.trace((Object)("Extra property: " + properties[i].RS_toXML()));
                    try {
                        Document datadom2 = datadb.parse(new InputSource(new StringReader(properties[i].RS_toXML())));
                        Element imp2 = datadom2.getDocumentElement();
                        Node dup = datadom.importNode(imp2, true);
                        imp.appendChild(dup);
                        continue;
                    }
                    catch (Exception e) {
                        log.error((Object)"could not create custom property element", (Throwable)e);
                    }
                }
                log.info((Object)("Final Dom object " + this.getStringFromDocument(datadom)));
                allProperties = this.getStringFromDocument(datadom);
            }
            catch (Exception e) {
                log.error((Object)"Could not parse properties. Thorwing Exception", (Throwable)e);
                throw new Exception("Could not parse properties");
            }
            log.info((Object)("Custom properties: " + customProperties));
            RSFullWriter writer = RSFullWriter.getRSFullWriter(allProperties);
            if (!(type instanceof RSResourceLocalType) && !(type instanceof RSResourceWSRFType)) {
                log.error((Object)"not regognized resource type.Throwing Exception");
                throw new Exception("not regognized resource type.Throwing Exception");
            }
            MakeLocalThreadGeneric worker = new MakeLocalThreadGeneric(writer, thisReader, MakeLocalThreadGeneric.CLEAR, waittime, this.rs.getStaticPort(), this.rs.getSSLsupport());
            worker.start();
            return RSXMLReader.getRSXMLReader(writer.getRSLocator(type));
        }
        catch (Exception e) {
            log.error((Object)"Could not make local. Throwing Exception", (Throwable)e);
            throw new Exception("Could not make local");
        }
    }

    @Override
    public RSXMLReader makeLocal(RSResourceType type) throws Exception {
        try {
            if (!(!this.isLocal() || this.rs.isForward() || this.rs.hasAccessLeasing() || this.rs.hasTimeLeasing() || this.rs.isSecure() || this.rs.isScoped())) {
                if (this.rs.getRSLocator().getRSResourceType() instanceof RSResourceLocalType) {
                    return RSXMLReader.getRSXMLReader(this.rs.getRSLocator());
                }
                if (this.rs.getRSLocator().getRSResourceType() instanceof RSResourceWSRFType) {
                    RSLocator l = new RSLocator(new RSResourceLocalType(), this.rs.getHeadFileName());
                    return RSXMLReader.getRSXMLReader(l);
                }
                log.error((Object)"RSResource type not recognized. Throwing Exception");
                throw new Exception("RSResource type not recognized");
            }
            RSReader thisReader = RSReader.getRSReader(this.getRSLocator());
            String properties = thisReader.retrieveCustomProperties();
            RSFullWriter writer = RSFullWriter.getRSFullWriter(properties);
            if (!(type instanceof RSResourceLocalType) && !(type instanceof RSResourceWSRFType)) {
                log.error((Object)"not regognized resource type.Throwing Exception");
                throw new Exception("not regognized resource type.Throwing Exception");
            }
            MakeLocalThreadGeneric worker = new MakeLocalThreadGeneric(writer, thisReader, MakeLocalThreadGeneric.CLEAR, this.rs.getStaticPort(), this.rs.getSSLsupport());
            worker.start();
            return RSXMLReader.getRSXMLReader(writer.getRSLocator(type));
        }
        catch (Exception e) {
            log.error((Object)"Could not make local. Throwing Exception", (Throwable)e);
            throw new Exception("Could not make local");
        }
    }

    public RSXMLReader makeLocal(RSResourceType type, RSWriterCreationParams params, GCUBEScope scope) throws Exception {
        try {
            RSReader thisReader = RSReader.getRSReader(this.getRSLocator());
            RSFullWriter writer = RSFullWriter.getRSFullWriter(params);
            if (!(type instanceof RSResourceLocalType) && !(type instanceof RSResourceWSRFType)) {
                log.error((Object)"not regognized resource type.Throwing Exception");
                throw new Exception("not regognized resource type.Throwing Exception");
            }
            MakeLocalThreadGeneric worker = new MakeLocalThreadGeneric(writer, thisReader, MakeLocalThreadGeneric.CLEAR, this.rs.getStaticPort(), this.rs.getSSLsupport());
            worker.start();
            RSLocator newlocator = writer.getRSLocator(type, scope, params.getPrivKey());
            newlocator.setPrivKey(params.getPrivKey());
            newlocator.setScope(scope);
            return RSXMLReader.getRSXMLReader(newlocator);
        }
        catch (Exception e) {
            log.error((Object)"Could not make local. Throwing Exception", (Throwable)e);
            throw new Exception("Could not make local");
        }
    }

    @Override
    public RSXMLReader makeLocal(RSResourceType type, int count) throws Exception {
        if (count < 0) {
            log.error((Object)"invalid topCount argument. Throwing Exception");
            throw new Exception("invalid topCount argument");
        }
        try {
            return this.keepTop(count).makeLocal(type);
        }
        catch (Exception e) {
            log.error((Object)"could not perform partial localization. Throwing Exception", (Throwable)e);
            throw new Exception("could not perform partial localization");
        }
    }

    @Override
    public RSXMLReader keepTop(int count, PropertyElementBase[] properties) throws Exception {
        try {
            if (properties == null || properties.length == 0) {
                log.error((Object)"Cannot initialize Result Set with empty property list. Throwing Exception");
                throw new Exception("Cannot initialize Result Set with empty property list");
            }
            String[] props = new String[properties.length];
            for (int i = 0; i < properties.length; ++i) {
                props[i] = properties[i].RS_toXML();
            }
            String headName = this.rs.keepTop(count, props, KeepTopThreadGeneric.PERRECORD);
            RSLocator newLocator = null;
            newLocator = this.getRSLocator().getRSResourceType() instanceof RSResourceLocalType ? new RSLocator(new RSResourceLocalType(), headName) : this.rs.wrap(new RSResourceWSRFType(), headName, this.getRSLocator().getURI().toString());
            return RSXMLReader.getRSXMLReader(newLocator);
        }
        catch (Exception e) {
            log.error((Object)"Could not keep top. Throwing Exception", (Throwable)e);
            throw new Exception("Could not keep top");
        }
    }

    @Override
    public RSXMLReader keepTop(int count) throws Exception {
        try {
            String headName = this.rs.keepTop(count, KeepTopThreadGeneric.PERRECORD);
            RSLocator newLocator = null;
            newLocator = this.getRSLocator().getRSResourceType() instanceof RSResourceLocalType ? new RSLocator(new RSResourceLocalType(), headName) : this.rs.wrap(new RSResourceWSRFType(), headName, this.getRSLocator().getURI().toString());
            return RSXMLReader.getRSXMLReader(newLocator);
        }
        catch (Exception e) {
            log.error((Object)"Could not keep top. Throwing Exception", (Throwable)e);
            throw new Exception("Could not keep top");
        }
    }

    @Override
    public RSXMLReader cloneRS() throws Exception {
        try {
            return RSXMLReader.getRSXMLReader(super.cloneRS().getRSLocator());
        }
        catch (Exception e) {
            log.error((Object)"Could not clone rs. Throwing Exception", (Throwable)e);
            throw new Exception("Could not clone rs");
        }
    }

    public String getFullPayload() throws Exception {
        try {
            return this.rs.getCurrentContentPartPayload();
        }
        catch (Exception e) {
            log.error((Object)"Could not get payload. Throwing Exception", (Throwable)e);
            throw new Exception("Could not get payload");
        }
    }
}

