/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.searchlibrary.rsreader;

import org.apache.log4j.Logger;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBase;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSXMLReader;

public class RSXMLIterator {
    private static Logger log = Logger.getLogger(RSXMLIterator.class);
    private RSXMLReader reader = null;
    private int currentRecord = -1;
    private int waittime = 300000;

    protected RSXMLIterator(RSXMLReader reader) throws Exception {
        if (reader == null) {
            log.error((Object)"Cannot initialize with null reader. Throwing Exception");
            throw new Exception("Cannot initialize with null reader");
        }
        this.reader = reader;
        this.currentRecord = -1;
    }

    protected RSXMLIterator(RSXMLReader reader, int waittime) throws Exception {
        if (reader == null) {
            log.error((Object)"Cannot initialize with null reader. Throwing Exception");
            throw new Exception("Cannot initialize with null reader");
        }
        this.reader = reader;
        this.currentRecord = -1;
        this.waittime = waittime;
    }

    public boolean hasNext() {
        try {
            if (this.currentRecord < 0) {
                while (this.reader.getNumberOfResults() <= 0) {
                    if (this.reader.getNextPart(this.waittime)) continue;
                    return false;
                }
                this.currentRecord = 0;
                return true;
            }
            if (this.currentRecord <= this.reader.getNumberOfResults() - 1) {
                return true;
            }
            if (!this.reader.getNextPart(this.waittime)) {
                return false;
            }
            while (this.reader.getNumberOfResults() <= 0) {
                if (this.reader.getNextPart(this.waittime)) continue;
                return false;
            }
            this.currentRecord = 0;
            return true;
        }
        catch (Exception e) {
            log.error((Object)"Error while trying for has next. Returning false", (Throwable)e);
            return false;
        }
    }

    public ResultElementBase next(Class template) {
        try {
            ResultElementBase tmp = this.reader.getResults(template, this.currentRecord);
            if (tmp == null) {
                log.error((Object)"retrieved record is null. Throwing Exception");
                throw new Exception("retrieved record is null");
            }
            ++this.currentRecord;
            return tmp;
        }
        catch (Exception e) {
            log.error((Object)"could not retrieve result. Returning null", (Throwable)e);
            ++this.currentRecord;
            return null;
        }
    }
}

