/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.searchlibrary.rswriter;

import java.io.File;
import java.io.StringReader;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.log4j.Logger;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementBase;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementGC;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementType;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementURIValidation;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementXSDContentValidation;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementBase;
import org.gcube.common.searchservice.searchlibrary.resultset.helpers.RSConstants;
import org.gcube.common.searchservice.searchlibrary.resultset.helpers.RSFileHelper;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.ForceProductionTask;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocator;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.pool.RSPoolObject;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSFullWriter;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSWriterCreationParams;

public class RSXMLWriter
extends RSPoolObject {
    private static Logger log = Logger.getLogger(RSXMLWriter.class);
    private Object synchAddition = null;
    private RSFullWriter writer = null;
    private Vector<ResultElementBase> records = null;
    private int size = 0;
    private Timer timer = null;
    private ForceProductionTask task = null;
    private Validator validationElement = null;
    int recsPerCount = 20;
    int partSize = 102400;
    private RSWriterCreationParams attributes = null;

    public static RSXMLWriter getRSXMLWriter(RSWriterCreationParams intParams) throws Exception {
        intParams.properties.add((PropertyElementBase)new PropertyElementGC(PropertyElementGC.unspecified));
        intParams.properties.add((PropertyElementBase)new PropertyElementType(PropertyElementType.XML));
        return new RSXMLWriter(intParams, RSFullWriter.getRSFullWriter(intParams));
    }

    public static RSXMLWriter getRSXMLWriter() throws Exception {
        try {
            return new RSXMLWriter(RSFullWriter.getRSFullWriter(new PropertyElementBase[]{new PropertyElementGC(PropertyElementGC.unspecified), new PropertyElementType(PropertyElementType.XML)}), null);
        }
        catch (Exception e) {
            log.error((Object)"could not create RSSimpelWriter. Throwing Exception", (Throwable)e);
            throw new Exception("could not create RSSimpelWriter");
        }
    }

    public static RSXMLWriter getRSXMLWriter(boolean dataFlow) throws Exception {
        try {
            return new RSXMLWriter(RSFullWriter.getRSFullWriter(new PropertyElementBase[]{new PropertyElementGC(PropertyElementGC.unspecified), new PropertyElementType(PropertyElementType.XML)}, dataFlow), null);
        }
        catch (Exception e) {
            log.error((Object)"could not create RSSimpelWriter. Throwing Exception", (Throwable)e);
            throw new Exception("could not create RSSimpelWriter");
        }
    }

    public static RSXMLWriter getRSXMLWriter(int recsPerPart, int partSize) throws Exception {
        try {
            if (recsPerPart <= 0 || partSize <= 0) {
                log.error((Object)("One or more Illegal values in " + recsPerPart + " or " + partSize));
                throw new Exception("One or more Illegal values in " + recsPerPart + " or " + partSize);
            }
            return new RSXMLWriter(RSFullWriter.getRSFullWriter(new PropertyElementBase[]{new PropertyElementGC(PropertyElementGC.unspecified), new PropertyElementType(PropertyElementType.XML)}), recsPerPart, partSize, null);
        }
        catch (Exception e) {
            log.error((Object)"could not create RSSimpelWriter. Throwing Exception", (Throwable)e);
            throw new Exception("could not create RSSimpelWriter");
        }
    }

    public static RSXMLWriter getRSXMLWriter(int recsPerPart, int partSize, boolean dataFlow) throws Exception {
        try {
            if (recsPerPart <= 0 || partSize <= 0) {
                log.error((Object)("One or more Illegal values in " + recsPerPart + " or " + partSize));
                throw new Exception("One or more Illegal values in " + recsPerPart + " or " + partSize);
            }
            return new RSXMLWriter(RSFullWriter.getRSFullWriter(new PropertyElementBase[]{new PropertyElementGC(PropertyElementGC.unspecified), new PropertyElementType(PropertyElementType.XML)}, dataFlow), recsPerPart, partSize, null);
        }
        catch (Exception e) {
            log.error((Object)"could not create RSSimpelWriter. Throwing Exception", (Throwable)e);
            throw new Exception("could not create RSSimpelWriter");
        }
    }

    public static RSXMLWriter getRSXMLWriter(PropertyElementBase[] properties) throws Exception {
        try {
            PropertyElementBase[] props = new PropertyElementBase[properties.length + 1];
            System.arraycopy(properties, 0, props, 0, properties.length);
            props[properties.length] = new PropertyElementType(PropertyElementType.XML);
            return new RSXMLWriter(RSFullWriter.getRSFullWriter(props), properties);
        }
        catch (Exception e) {
            log.error((Object)"could not create RSSimpelWriter. Throwing Exception", (Throwable)e);
            throw new Exception("could not create RSSimpelWriter");
        }
    }

    public static RSXMLWriter getRSXMLWriter(PropertyElementBase[] properties, boolean dataFlow) throws Exception {
        try {
            PropertyElementBase[] props = new PropertyElementBase[properties.length + 1];
            System.arraycopy(properties, 0, props, 0, properties.length);
            props[properties.length] = new PropertyElementType(PropertyElementType.XML);
            return new RSXMLWriter(RSFullWriter.getRSFullWriter(props, dataFlow), properties);
        }
        catch (Exception e) {
            log.error((Object)"could not create RSSimpelWriter. Throwing Exception", (Throwable)e);
            throw new Exception("could not create RSSimpelWriter");
        }
    }

    public static RSXMLWriter getRSXMLWriter(PropertyElementBase[] properties, int recsPerPart, int partSize) throws Exception {
        try {
            if (recsPerPart <= 0 || partSize <= 0) {
                log.error((Object)("One or more Illegal values in " + recsPerPart + " or " + partSize));
                throw new Exception("One or more Illegal values in " + recsPerPart + " or " + partSize);
            }
            PropertyElementBase[] props = new PropertyElementBase[properties.length + 1];
            System.arraycopy(properties, 0, props, 0, properties.length);
            props[properties.length] = new PropertyElementType(PropertyElementType.XML);
            return new RSXMLWriter(RSFullWriter.getRSFullWriter(props), recsPerPart, partSize, properties);
        }
        catch (Exception e) {
            log.error((Object)"could not create RSSimpelWriter. Throwing Exception", (Throwable)e);
            throw new Exception("could not create RSSimpelWriter");
        }
    }

    public static RSXMLWriter getRSXMLWriter(PropertyElementBase[] properties, int recsPerPart, int partSize, boolean dataFlow) throws Exception {
        try {
            if (recsPerPart <= 0 || partSize <= 0) {
                log.error((Object)("One or more Illegal values in " + recsPerPart + " or " + partSize));
                throw new Exception("One or more Illegal values in " + recsPerPart + " or " + partSize);
            }
            PropertyElementBase[] props = new PropertyElementBase[properties.length + 1];
            System.arraycopy(properties, 0, props, 0, properties.length);
            props[properties.length] = new PropertyElementType(PropertyElementType.XML);
            return new RSXMLWriter(RSFullWriter.getRSFullWriter(props, dataFlow), recsPerPart, partSize, properties);
        }
        catch (Exception e) {
            log.error((Object)"could not create RSSimpelWriter. Throwing Exception", (Throwable)e);
            throw new Exception("could not create RSSimpelWriter");
        }
    }

    private void getValidator(PropertyElementBase[] properties) throws Exception {
        if (properties == null || properties.length == 0) {
            this.validationElement = null;
            return;
        }
        String xsd = null;
        for (int i = 0; i < properties.length; ++i) {
            if (properties[i] instanceof PropertyElementURIValidation) {
                xsd = new String(RSFileHelper.getBytesFromFile((File)new File(((PropertyElementURIValidation)properties[i]).getURIxsd())));
                continue;
            }
            if (!(properties[i] instanceof PropertyElementURIValidation)) continue;
            xsd = new String(((PropertyElementXSDContentValidation)properties[i]).getContentXSD());
        }
        if (xsd == null) {
            this.validationElement = null;
            return;
        }
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        StreamSource schemaSource = new StreamSource(new StringReader(xsd));
        Schema schema = factory.newSchema(schemaSource);
        this.validationElement = schema.newValidator();
    }

    private boolean validate(String xml) {
        if (this.validationElement == null) {
            return true;
        }
        try {
            this.validationElement.validate(new StreamSource(new StringReader(xml)));
        }
        catch (Exception e) {
            log.error((Object)"could not validate record. returning false", (Throwable)e);
            return false;
        }
        return true;
    }

    protected RSXMLWriter(RSWriterCreationParams initParams, RSFullWriter writer) throws Exception {
        this.attributes = initParams;
        if (this.attributes.getPartSize() != -1) {
            this.partSize = this.attributes.getPartSize();
        }
        if (this.attributes.getRecsPerPart() != -1) {
            this.recsPerCount = this.attributes.getRecsPerPart();
        }
        this.writer = writer;
        this.records = new Vector();
        this.synchAddition = new Object();
        this.getValidator(this.attributes.properties.toArray(new PropertyElementBase[this.attributes.properties.size()]));
    }

    protected RSXMLWriter(RSFullWriter writer, PropertyElementBase[] properties) throws Exception {
        this.writer = writer;
        this.records = new Vector();
        this.synchAddition = new Object();
        this.getValidator(properties);
    }

    protected RSXMLWriter(RSFullWriter writer, int recsPerPart, int partSize, PropertyElementBase[] properties) throws Exception {
        this.writer = writer;
        this.records = new Vector();
        this.recsPerCount = recsPerPart;
        this.partSize = partSize;
        this.synchAddition = new Object();
        this.getValidator(properties);
    }

    public boolean setTimer(long delay, long period, int times) {
        if (this.timer != null || this.task != null || times <= 0) {
            return false;
        }
        try {
            this.timer = new Timer();
            this.task = new ForceProductionTask(this, this.synchAddition, times);
            this.timer.schedule((TimerTask)this.task, delay, period);
            return true;
        }
        catch (Exception e) {
            log.error((Object)"Caught Exception while trying to create Timer. returning false", (Throwable)e);
            return false;
        }
    }

    public boolean resetTimer() {
        if (this.timer == null && this.task == null) {
            return false;
        }
        if (this.task != null) {
            this.task.cancel();
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = null;
        this.task = null;
        return true;
    }

    public boolean isTimerAlive() {
        if (this.timer == null || this.task == null) {
            return false;
        }
        return this.task.isAlive();
    }

    public void setRecsPerPart(int rpp) throws Exception {
        if (rpp <= 0) {
            log.error((Object)("Could not set RecsPerPart. Illegal value " + rpp));
            throw new Exception("Could not set RecsPerPart. Illegal value " + rpp);
        }
        this.recsPerCount = rpp;
    }

    public void setPartSize(int partSize) throws Exception {
        if (partSize <= 0) {
            log.error((Object)("Could not set PartSize. Illegal value " + partSize));
            throw new Exception("Could not set PartSize. Illegal value " + partSize);
        }
        this.partSize = partSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RSLocator getRSLocator(RSResourceType type, GCUBEScope scope) throws Exception {
        try {
            Object object = this.synchAddition;
            synchronized (object) {
                return this.writer.getRSLocator(type, scope);
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not retrieve RSLocator. Throwing Exception", (Throwable)e);
            throw new Exception("Could not retrieve RSLocator");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RSLocator getRSLocator(RSResourceType type) throws Exception {
        try {
            Object object = this.synchAddition;
            synchronized (object) {
                return this.writer.getRSLocator(type);
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not retrieve RSLocator. Throwing Exception", (Throwable)e);
            throw new Exception("Could not retrieve RSLocator");
        }
    }

    public RSConstants.CONTROLFLOW more(long time) throws Exception {
        try {
            return this.writer.more(time);
        }
        catch (Exception e) {
            log.error((Object)"Could not check if more records are needed. Throwing Exception", (Throwable)e);
            throw new Exception("Could not check if more records are needed");
        }
    }

    public boolean isFlowControled() throws Exception {
        return this.writer.isFlowControled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResults(ResultElementBase record) throws Exception {
        if (this.records == null) {
            log.error((Object)"records vector is null. Incorrect initialization incorrect. Throwing Exception");
            throw new Exception("records vector is null. Incorrect initialization incorrect");
        }
        Object object = this.synchAddition;
        synchronized (object) {
            try {
                if (this.validationElement != null && !this.validate(record.toXML())) {
                    log.error((Object)"could not validate record. thrpwing Exception");
                    throw new Exception("could not validate record");
                }
                this.size += record.RS_toXML().getBytes().length;
                if (this.records.size() + 1 >= this.recsPerCount) {
                    ResultElementBase[] res = new ResultElementBase[this.records.size() + 1];
                    for (int i = 0; i < this.records.size(); ++i) {
                        res[i] = this.records.get(i);
                    }
                    res[this.records.size()] = record;
                    this.writer.addResults(res);
                    this.writer.startNewPart();
                    this.size = 0;
                    this.records.clear();
                } else {
                    this.records.add(record);
                }
                if (this.size > this.partSize) {
                    this.writeThrough();
                }
            }
            catch (Exception e) {
                log.error((Object)"Could not perform addition. Throwing Exception", (Throwable)e);
                throw new Exception("Could not perform addition");
            }
        }
    }

    public boolean writeThrough() throws Exception {
        if (this.records == null) {
            log.error((Object)"records vector is null. Incorrect initialization incorrect. Throwing Exception");
            throw new Exception("records vector is null. Incorrect initialization incorrect");
        }
        Object object = this.synchAddition;
        synchronized (object) {
            try {
                if (this.records.size() > 0) {
                    ResultElementBase[] res = new ResultElementBase[this.records.size()];
                    for (int i = 0; i < this.records.size(); ++i) {
                        res[i] = this.records.get(i);
                    }
                    this.writer.addResults(res);
                    this.writer.startNewPart();
                    this.size = 0;
                    this.records.clear();
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                log.error((Object)"Could not perform writeTrhough. Throwing Exception", (Throwable)e);
                throw new Exception("Could not perform writeTrhough");
            }
        }
    }

    public void force() throws Exception {
        try {
            if (!this.writeThrough()) {
                this.writer.startNewPart();
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not perform force. Throwing Exception", (Throwable)e);
            throw new Exception("Could not perform force");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResults(ResultElementBase[] record) throws Exception {
        if (this.records == null) {
            log.error((Object)"records vector is null. Incorrect initialization incorrect. Throwing Exception");
            throw new Exception("records vector is null. Incorrect initialization incorrect");
        }
        Object object = this.synchAddition;
        synchronized (object) {
            try {
                for (int i = 0; i < record.length; ++i) {
                    this.addResults(record[i]);
                }
            }
            catch (Exception e) {
                log.error((Object)"Could not perform addition. Throwing Exception", (Throwable)e);
                throw new Exception("Could not perform addition");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        if (this.records == null) {
            this.resetTimer();
            log.error((Object)"records vector is null. Incorrect initialization incorrect. Throwing Exception");
            throw new Exception("records vector is null. Incorrect initialization incorrect");
        }
        this.resetTimer();
        Object object = this.synchAddition;
        synchronized (object) {
            try {
                if (this.records.size() > 0) {
                    ResultElementBase[] res = new ResultElementBase[this.records.size()];
                    for (int i = 0; i < this.records.size(); ++i) {
                        res[i] = this.records.get(i);
                    }
                    this.writer.addResults(res);
                    this.size = 0;
                    this.records.clear();
                }
                this.force();
                this.writer.endAuthoring();
            }
            catch (Exception e) {
                log.error((Object)"Could not perform addition. Throwing Exception", (Throwable)e);
                throw new Exception("Could not perform addition");
            }
        }
    }

    public void overrideProperties(PropertyElementBase[] properties) throws Exception {
        try {
            this.writer.overrideProperties(properties);
        }
        catch (Exception e) {
            log.error((Object)"could not override properties. Throwing Exception", (Throwable)e);
            throw new Exception("could not override properties");
        }
    }

    public void overrideProperties(String properties) throws Exception {
        try {
            this.writer.overrideProperties(properties);
        }
        catch (Exception e) {
            log.error((Object)"could not override properties. Throwing Exception", (Throwable)e);
            throw new Exception("could not override properties");
        }
    }

    public void disableAccessLeasing() throws Exception {
        this.writer.disableAccessLeasing();
    }

    public void extendAccessLeasing(int extend) throws Exception {
        this.writer.extendAccessLeasing(extend);
    }

    public int getAccessLeasing() throws Exception {
        return this.writer.getAccessLeasing();
    }

    public boolean isForward() throws Exception {
        return this.writer.isForward();
    }

    public boolean setForward(boolean f) throws Exception {
        return this.writer.setForward(f);
    }

    public Date getTimeLeasing() throws Exception {
        return this.writer.getTimeLeasing();
    }

    public boolean extendTimeLeasing(Date extend) throws Exception {
        return this.writer.extendTimeLeasing(extend);
    }

    public void disableTimeLeasing() throws Exception {
        this.writer.disableTimeLeasing();
    }
}

