/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.searchlibrary.rsclient.elements;

import java.io.StringReader;
import java.net.URI;
import java.rmi.Remote;
import java.security.PrivateKey;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.log4j.Logger;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.searchservice.resultsetservice.ResultSetQNames;
import org.gcube.common.searchservice.resultsetservice.stubs.AccessResourceRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.AccessResourceResponse;
import org.gcube.common.searchservice.resultsetservice.stubs.CanStreamResponse;
import org.gcube.common.searchservice.resultsetservice.stubs.ExecuteQueryOnDocumentRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.ExecuteQueryOnHeadRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.ExecuteQueryOnResultsRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.FilterRSPropRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.FilterRSRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.GetFileContentRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.GetNextPartRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.GetNumberOfResultsRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.GetPropertiesRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.GetResultRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.GetResultsRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.KeepTopPropRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.KeepTopRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.ResultSetPortType;
import org.gcube.common.searchservice.resultsetservice.stubs.TransformByXSLTRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.TransformRSPropRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.TransformRSRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.WrapResourceRequest;
import org.gcube.common.searchservice.resultsetservice.stubs.WrapResourceResponse;
import org.gcube.common.searchservice.resultsetservice.stubs.service.ResultSetServiceAddressingLocator;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.WSRSSessionToken;
import org.gcube.common.searchservice.searchlibrary.resultset.helpers.RSConstants;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocator;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceWSRFType;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceWSType;
import org.globus.wsrf.container.ServiceHost;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.xml.sax.InputSource;
import sun.misc.BASE64Encoder;

public class RSTypeWrapper {
    private static Logger log = Logger.getLogger(RSTypeWrapper.class);
    private ResultSetPortType rrs = null;
    private RSLocator locator = null;
    private int port = -1;
    private boolean SSLsupport = true;

    public static boolean isWSRFType(String locatorString) {
        try {
            ObjectDeserializer.deserialize((InputSource)new InputSource(new StringReader(locatorString)), EndpointReferenceType.class);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public int getPort() {
        return this.port;
    }

    public boolean getSSLsupport() {
        return this.SSLsupport;
    }

    public static boolean isWSType(String locatorString) {
        try {
            WSRSSessionToken.deserialize((String)locatorString);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static URI getURIofWSRF(String locatorString) throws Exception {
        EndpointReferenceType instanceEPR = (EndpointReferenceType)ObjectDeserializer.deserialize((InputSource)new InputSource(new StringReader(locatorString)), EndpointReferenceType.class);
        return new URI(instanceEPR.getAddress().toString());
    }

    public static URI getURIofWS(String locatorString) throws Exception {
        WSRSSessionToken instanceEPR = WSRSSessionToken.deserialize((String)locatorString);
        return new URI(instanceEPR.getServiceInstance());
    }

    public static URI retrieveServiceHostBasePath() throws Exception {
        return new URI(ServiceHost.getBaseURL().toString());
    }

    public static RSLocator getLocator(EndpointReferenceType epr) throws Exception {
        return new RSLocator(ObjectSerializer.toString((Object)epr, (QName)ResultSetQNames.RESOURCE_REFERENCE));
    }

    public static RSLocator retrieveWSRFLocator(String serviceEndPoint, String headFileName, GCUBEScope scope, PrivateKey pKey) throws Exception {
        ResultSetPortType resultsetFactory;
        RSLocator remoteLocator = null;
        EndpointReferenceType instanceEPR = null;
        EndpointReferenceType factoryEPR = new EndpointReferenceType();
        try {
            factoryEPR.setAddress((AttributedURI)new Address(serviceEndPoint));
        }
        catch (Exception e) {
            log.error((Object)"could not initiliaze factory EPR. Throwing Exception", (Throwable)e);
            throw new Exception("could not initiliaze factory EPR");
        }
        ResultSetServiceAddressingLocator factoryLocator = new ResultSetServiceAddressingLocator();
        try {
            resultsetFactory = factoryLocator.getResultSetPortTypePort(factoryEPR);
            if (scope != null) {
                resultsetFactory = (ResultSetPortType)GCUBERemotePortTypeContext.getProxy((Remote)resultsetFactory, (GCUBEScope)scope, (GCUBESecurityManager[])new GCUBESecurityManager[0]);
            }
        }
        catch (Exception e) {
            log.error((Object)"could not initiliaze factory porttype. Throwing Exception", (Throwable)e);
            throw new Exception("could not initiliaze factory porttype");
        }
        try {
            WrapResourceRequest req = new WrapResourceRequest();
            req.setHeadFileName(headFileName);
            req.setResourceType(RSConstants.RESOURCETYPE.WSRF.toString());
            if (pKey != null) {
                req.setPrivateKey(new BASE64Encoder().encode(pKey.getEncoded()).getBytes());
            }
            WrapResourceResponse wrapResponse = resultsetFactory.wrapResource(req);
            instanceEPR = wrapResponse.getEndpointReference();
        }
        catch (Exception e) {
            log.error((Object)"could not wrap local resultset. Throwing Exception", (Throwable)e);
            throw new Exception("could not wrap local resultset");
        }
        try {
            remoteLocator = new RSLocator(ObjectSerializer.toString((Object)instanceEPR, (QName)ResultSetQNames.RESOURCE_REFERENCE));
            remoteLocator.setScope(scope);
        }
        catch (Exception e) {
            log.error((Object)"Could not create RSLocator", (Throwable)e);
            throw new Exception("Could not create RSLocator");
        }
        return remoteLocator;
    }

    public static RSLocator retrieveWSRFLocator(String serviceEndPoint, String headFileName) throws Exception {
        return RSTypeWrapper.retrieveWSRFLocator(serviceEndPoint, headFileName, null, null);
    }

    public static RSLocator retrieveWSRFLocator(String serviceEndPoint, String headFileName, PrivateKey pKey) throws Exception {
        return RSTypeWrapper.retrieveWSRFLocator(serviceEndPoint, headFileName, null, pKey);
    }

    public static RSLocator retrieveWSRFLocator(String serviceEndPoint, String headFileName, GCUBEScope scope) throws Exception {
        return RSTypeWrapper.retrieveWSRFLocator(serviceEndPoint, headFileName, scope, null);
    }

    public static RSLocator retrieveWSLocator(String serviceEndPoint, String headFileName, GCUBEScope scope, PrivateKey pKey) throws Exception {
        RSLocator remoteLocator = null;
        EndpointReferenceType endpoint = new EndpointReferenceType();
        endpoint.setAddress((AttributedURI)new Address(serviceEndPoint));
        ResultSetServiceAddressingLocator rlocator = new ResultSetServiceAddressingLocator();
        ResultSetPortType trrs = rlocator.getResultSetPortTypePort(endpoint);
        if (scope != null) {
            trrs = (ResultSetPortType)GCUBERemotePortTypeContext.getProxy((Remote)trrs, (GCUBEScope)scope, (GCUBESecurityManager[])new GCUBESecurityManager[0]);
        }
        WrapResourceRequest req = new WrapResourceRequest();
        req.setHeadFileName(headFileName);
        req.setResourceType(RSConstants.RESOURCETYPE.WS.toString());
        if (pKey != null) {
            req.setPrivateKey(new BASE64Encoder().encode(pKey.getEncoded()).getBytes());
        }
        WrapResourceResponse wrapResourceResponse = trrs.wrapResource(req);
        remoteLocator = new RSLocator(wrapResourceResponse.getSessionToken());
        remoteLocator.setScope(scope);
        return remoteLocator;
    }

    public static RSLocator retrieveWSLocator(String serviceEndPoint, String headFileName, GCUBEScope scope) throws Exception {
        return RSTypeWrapper.retrieveWSLocator(serviceEndPoint, headFileName, scope, null);
    }

    public static RSLocator retrieveWSLocator(String serviceEndPoint, String headFileName) throws Exception {
        return RSTypeWrapper.retrieveWSLocator(serviceEndPoint, headFileName, null, null);
    }

    public static RSLocator retrieveWSLocator(String serviceEndPoint, String headFileName, PrivateKey pKey) throws Exception {
        return RSTypeWrapper.retrieveWSLocator(serviceEndPoint, headFileName, null, pKey);
    }

    private void InitRSTypeWrapper(RSLocator locator, GCUBEScope scope, PrivateKey pKey) throws Exception {
        block22: {
            if (locator.getRSResourceType() instanceof RSResourceWSRFType) {
                try {
                    EndpointReferenceType instanceEPR = null;
                    ResultSetServiceAddressingLocator instanceLocator = new ResultSetServiceAddressingLocator();
                    ResultSetPortType resultset = null;
                    try {
                        instanceEPR = (EndpointReferenceType)ObjectDeserializer.deserialize((InputSource)new InputSource(new StringReader(locator.getLocator())), EndpointReferenceType.class);
                    }
                    catch (Exception e) {
                        log.error((Object)"Could not retrieve EndPointReferenceType. Throwsing Exception", (Throwable)e);
                        throw new Exception("Could not retrieve EndPointReferenceType");
                    }
                    try {
                        resultset = instanceLocator.getResultSetPortTypePort(instanceEPR);
                        if (scope != null) {
                            resultset = (ResultSetPortType)GCUBERemotePortTypeContext.getProxy((Remote)resultset, (GCUBEScope)scope, (GCUBESecurityManager[])new GCUBESecurityManager[0]);
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)"Could not retrieve PortType. Throwsing Exception", (Throwable)e);
                        throw new Exception("Could not retrieve PortType");
                    }
                    try {
                        AccessResourceRequest req = new AccessResourceRequest();
                        req.setSessionToken(locator.getSessionToken());
                        req.setResourceType(RSConstants.RESOURCETYPE.WSRF.toString());
                        if (pKey != null) {
                            req.setPrivateKey(new BASE64Encoder().encode(pKey.getEncoded()).getBytes());
                        }
                        AccessResourceResponse accessResourceResponse = resultset.accessResource(req);
                        instanceEPR = accessResourceResponse.getEndpointReference();
                        this.port = accessResourceResponse.getPort();
                        this.SSLsupport = accessResourceResponse.isSSLsupport();
                    }
                    catch (Exception e) {
                        log.error((Object)"Could not retrieve EPR to new Resource. Throwsing Exception", (Throwable)e);
                        throw new Exception("Could not retrieve EPR to new Resource");
                    }
                    try {
                        this.rrs = instanceLocator.getResultSetPortTypePort(instanceEPR);
                        if (scope != null) {
                            this.rrs = (ResultSetPortType)GCUBERemotePortTypeContext.getProxy((Remote)this.rrs, (GCUBEScope)scope, (GCUBESecurityManager[])new GCUBESecurityManager[0]);
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)"Could not retrieve porttype to new Resource. Throwsing Exception", (Throwable)e);
                        throw new Exception("Could not retrieve porttype to new Resource");
                    }
                    try {
                        this.locator = new RSLocator(ObjectSerializer.toString((Object)instanceEPR, (QName)ResultSetQNames.RESOURCE_REFERENCE));
                        this.locator.setScope(scope);
                        this.locator.setPrivKey(pKey);
                        break block22;
                    }
                    catch (Exception e) {
                        log.error((Object)"Could not create locator for new Resource. Throwsing Exception", (Throwable)e);
                        throw new Exception("Could not create locator for new Resource");
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Could not created RSLocationWrapper. Throwsing Exception", (Throwable)e);
                    throw new Exception("Could not created RSLocationWrapper");
                }
            }
            if (locator.getRSResourceType() instanceof RSResourceWSType) {
                try {
                    EndpointReferenceType endpoint = new EndpointReferenceType();
                    endpoint.setAddress((AttributedURI)new Address(locator.getURI().toString()));
                    ResultSetServiceAddressingLocator rlocator = new ResultSetServiceAddressingLocator();
                    this.rrs = rlocator.getResultSetPortTypePort(endpoint);
                    if (scope != null) {
                        this.rrs = (ResultSetPortType)GCUBERemotePortTypeContext.getProxy((Remote)this.rrs, (GCUBEScope)scope, (GCUBESecurityManager[])new GCUBESecurityManager[0]);
                    }
                    AccessResourceRequest req = new AccessResourceRequest();
                    req.setSessionToken(locator.getSessionToken());
                    req.setResourceType(RSConstants.RESOURCETYPE.WS.toString());
                    if (pKey != null) {
                        req.setPrivateKey(new BASE64Encoder().encode(pKey.getEncoded()).getBytes());
                    }
                    AccessResourceResponse accessResourceResponse = this.rrs.accessResource(req);
                    this.port = accessResourceResponse.getPort();
                    this.SSLsupport = accessResourceResponse.isSSLsupport();
                    this.locator = new RSLocator(accessResourceResponse.getSessionToken());
                    this.locator.setScope(scope);
                    this.locator.setPrivKey(pKey);
                }
                catch (Exception e) {
                    log.error((Object)"Could not created RSLocationWrapper. Throwsing Exception", (Throwable)e);
                    throw new Exception("Could not created RSLocationWrapper");
                }
            } else {
                log.error((Object)"Unknown RSResourceType. Throwing Exception");
                throw new Exception("Unknown RSResourceType");
            }
        }
    }

    public RSTypeWrapper(RSResourceType type, String headFileName) throws Exception {
        this.InitRSTypeWrapper(type, headFileName, null, null);
    }

    public RSTypeWrapper(RSResourceType type, String headFileName, GCUBEScope scope) throws Exception {
        this.InitRSTypeWrapper(type, headFileName, scope, null);
    }

    public RSTypeWrapper(RSResourceType type, String headFileName, GCUBEScope scope, PrivateKey pKey) throws Exception {
        this.InitRSTypeWrapper(type, headFileName, scope, pKey);
    }

    public RSTypeWrapper(RSResourceType type, String headFileName, PrivateKey pKey) throws Exception {
        this.InitRSTypeWrapper(type, headFileName, null, pKey);
    }

    private void InitRSTypeWrapper(RSResourceType type, String headFileName, GCUBEScope scope, PrivateKey pKey) throws Exception {
        if (type instanceof RSResourceWSRFType) {
            ResultSetPortType resultsetFactory;
            EndpointReferenceType instanceEPR = null;
            EndpointReferenceType factoryEPR = new EndpointReferenceType();
            try {
                factoryEPR.setAddress((AttributedURI)new Address(((RSResourceWSRFType)type).getServiceEndPoint().toString()));
            }
            catch (Exception e) {
                log.error((Object)"could not initiliaze factory EPR. Throwinf Exception", (Throwable)e);
                throw new Exception("could not initiliaze factory EPR");
            }
            ResultSetServiceAddressingLocator factoryLocator = new ResultSetServiceAddressingLocator();
            try {
                resultsetFactory = factoryLocator.getResultSetPortTypePort(factoryEPR);
                if (scope != null) {
                    resultsetFactory = (ResultSetPortType)GCUBERemotePortTypeContext.getProxy((Remote)resultsetFactory, (GCUBEScope)scope, (GCUBESecurityManager[])new GCUBESecurityManager[0]);
                }
            }
            catch (Exception e) {
                log.error((Object)"could not initiliaze factory porttype. Throwinf Exception", (Throwable)e);
                throw new Exception("could not initiliaze factory porttype");
            }
            try {
                WrapResourceRequest req = new WrapResourceRequest();
                req.setHeadFileName(headFileName);
                req.setResourceType(RSConstants.RESOURCETYPE.WSRF.toString());
                if (pKey != null) {
                    req.setPrivateKey(new BASE64Encoder().encode(pKey.getEncoded()).getBytes());
                }
                WrapResourceResponse wrapResponse = resultsetFactory.wrapResource(req);
                this.port = wrapResponse.getPort();
                this.SSLsupport = wrapResponse.isSSLsupport();
                instanceEPR = wrapResponse.getEndpointReference();
            }
            catch (Exception e) {
                log.error((Object)"could not wrap local resultset. Throwing Exception", (Throwable)e);
                throw new Exception("could not wrap local resultset");
            }
            try {
                this.locator = new RSLocator(ObjectSerializer.toString((Object)instanceEPR, (QName)ResultSetQNames.RESOURCE_REFERENCE));
                this.locator.setScope(scope);
                this.locator.setPrivKey(pKey);
            }
            catch (Exception e) {
                log.error((Object)"Could not create RSLocator", (Throwable)e);
                throw new Exception("Could not create RSLocator");
            }
        }
        if (type instanceof RSResourceWSType) {
            try {
                WrapResourceRequest req = new WrapResourceRequest();
                req.setHeadFileName(headFileName);
                req.setResourceType(RSConstants.RESOURCETYPE.WS.toString());
                EndpointReferenceType endpoint = new EndpointReferenceType();
                endpoint.setAddress((AttributedURI)new Address(((RSResourceWSType)type).getServiceEndPoint().toString()));
                ResultSetServiceAddressingLocator rlocator = new ResultSetServiceAddressingLocator();
                ResultSetPortType trrs = rlocator.getResultSetPortTypePort(endpoint);
                if (scope != null) {
                    trrs = (ResultSetPortType)GCUBERemotePortTypeContext.getProxy((Remote)trrs, (GCUBEScope)scope, (GCUBESecurityManager[])new GCUBESecurityManager[0]);
                }
                if (pKey != null) {
                    req.setPrivateKey(new BASE64Encoder().encode(pKey.getEncoded()).getBytes());
                }
                WrapResourceResponse wrapResourceResponse = trrs.wrapResource(req);
                this.port = wrapResourceResponse.getPort();
                this.SSLsupport = wrapResourceResponse.isSSLsupport();
                this.locator = new RSLocator(wrapResourceResponse.getSessionToken());
                this.locator.setScope(scope);
                this.locator.setPrivKey(pKey);
            }
            catch (Exception e) {
                log.error((Object)"Could not wrap resource. Throwsing Exception", (Throwable)e);
                throw new Exception("Could not wrap resource");
            }
        } else {
            log.error((Object)"Not suported RSResourceType. Throwing Exception");
            throw new Exception("Not suported RSResourceType");
        }
    }

    private void InitRSTypeWrapper(RSResourceType type, String headName, String serviceEndPoint, GCUBEScope scope, PrivateKey pKey) throws Exception {
        if (type instanceof RSResourceWSRFType) {
            ResultSetPortType resultsetFactory;
            EndpointReferenceType instanceEPR = null;
            EndpointReferenceType factoryEPR = new EndpointReferenceType();
            try {
                factoryEPR.setAddress((AttributedURI)new Address(serviceEndPoint));
            }
            catch (Exception e) {
                log.error((Object)"could not initiliaze factory EPR. Throwinf Exception", (Throwable)e);
                throw new Exception("could not initiliaze factory EPR");
            }
            ResultSetServiceAddressingLocator factoryLocator = new ResultSetServiceAddressingLocator();
            try {
                resultsetFactory = factoryLocator.getResultSetPortTypePort(factoryEPR);
                if (scope != null) {
                    resultsetFactory = (ResultSetPortType)GCUBERemotePortTypeContext.getProxy((Remote)resultsetFactory, (GCUBEScope)scope, (GCUBESecurityManager[])new GCUBESecurityManager[0]);
                }
            }
            catch (Exception e) {
                log.error((Object)"could not initiliaze factory porttype. Throwinf Exception", (Throwable)e);
                throw new Exception("could not initiliaze factory porttype");
            }
            try {
                WrapResourceRequest req = new WrapResourceRequest();
                req.setHeadFileName(headName);
                req.setResourceType(RSConstants.RESOURCETYPE.WSRF.toString());
                if (pKey != null) {
                    req.setPrivateKey(new BASE64Encoder().encode(pKey.getEncoded()).getBytes());
                }
                WrapResourceResponse wrapResponse = resultsetFactory.wrapResource(req);
                this.port = wrapResponse.getPort();
                this.SSLsupport = wrapResponse.isSSLsupport();
                instanceEPR = wrapResponse.getEndpointReference();
            }
            catch (Exception e) {
                log.error((Object)"could not wrap local resultset. Throwing Exception", (Throwable)e);
                throw new Exception("could not wrap local resultset");
            }
            try {
                this.locator = new RSLocator(ObjectSerializer.toString((Object)instanceEPR, (QName)ResultSetQNames.RESOURCE_REFERENCE));
                this.locator.setScope(scope);
                this.locator.setPrivKey(pKey);
            }
            catch (Exception e) {
                log.error((Object)"Could not create RSLocator", (Throwable)e);
                throw new Exception("Could not create RSLocator");
            }
        }
        if (type instanceof RSResourceWSType) {
            try {
                EndpointReferenceType endpoint = new EndpointReferenceType();
                endpoint.setAddress((AttributedURI)new Address(serviceEndPoint));
                ResultSetServiceAddressingLocator rlocator = new ResultSetServiceAddressingLocator();
                ResultSetPortType trrs = rlocator.getResultSetPortTypePort(endpoint);
                if (scope != null) {
                    trrs = (ResultSetPortType)GCUBERemotePortTypeContext.getProxy((Remote)trrs, (GCUBEScope)scope, (GCUBESecurityManager[])new GCUBESecurityManager[0]);
                }
                WrapResourceRequest req = new WrapResourceRequest();
                req.setHeadFileName(headName);
                req.setResourceType(RSConstants.RESOURCETYPE.WS.toString());
                if (pKey != null) {
                    req.setPrivateKey(new BASE64Encoder().encode(pKey.getEncoded()).getBytes());
                }
                WrapResourceResponse wrapResourceResponse = trrs.wrapResource(req);
                this.port = wrapResourceResponse.getPort();
                this.SSLsupport = wrapResourceResponse.isSSLsupport();
                this.locator = new RSLocator(wrapResourceResponse.getSessionToken());
                this.locator.setScope(scope);
                this.locator.setPrivKey(pKey);
            }
            catch (Exception e) {
                log.error((Object)"could not wrap local resultset. Throwsing Exception", (Throwable)e);
                throw new Exception("could not wrap local resultset");
            }
        } else {
            log.error((Object)"Not supported RSResourceType. Throwing Exception");
            throw new Exception("Not supported RSResourceType");
        }
    }

    public RSTypeWrapper(RSLocator locator, GCUBEScope scope) throws Exception {
        this.InitRSTypeWrapper(locator, scope, locator.getPrivKey());
    }

    public RSTypeWrapper(RSLocator locator, GCUBEScope scope, PrivateKey pKey) throws Exception {
        this.InitRSTypeWrapper(locator, scope, pKey);
    }

    public RSTypeWrapper(RSLocator locator, PrivateKey pKey) throws Exception {
        GCUBEScope scope = locator.getScope();
        this.InitRSTypeWrapper(locator, scope, pKey);
    }

    public RSTypeWrapper(RSLocator locator) throws Exception {
        GCUBEScope scope = locator.getScope();
        PrivateKey pkey = locator.getPrivKey();
        this.InitRSTypeWrapper(locator, scope, pkey);
    }

    public RSTypeWrapper(RSResourceType type, String headName, String serviceEndPoint, GCUBEScope scope) throws Exception {
        this.InitRSTypeWrapper(type, headName, serviceEndPoint, scope, null);
    }

    public RSTypeWrapper(RSResourceType type, String headName, String serviceEndPoint, GCUBEScope scope, PrivateKey pKey) throws Exception {
        this.InitRSTypeWrapper(type, headName, serviceEndPoint, scope, pKey);
    }

    public RSTypeWrapper(RSResourceType type, String headName, String serviceEndPoint, PrivateKey pKey) throws Exception {
        this.InitRSTypeWrapper(type, headName, serviceEndPoint, null, pKey);
    }

    public RSTypeWrapper(RSResourceType type, String headName, String serviceEndPoint) throws Exception {
        this.InitRSTypeWrapper(type, headName, serviceEndPoint, null, null);
    }

    public RSLocator getLocator() {
        return this.locator;
    }

    public String getHeadFileName(String sessionToken) throws Exception {
        return this.rrs.getHeadFileName(sessionToken);
    }

    public CanStreamResponse canStream(String sessionToken) throws Exception {
        return this.rrs.canStream(sessionToken);
    }

    public void clear(String sessionToken) throws Exception {
        this.rrs.clear(sessionToken);
    }

    public String[] getProperties(String type, String sessionToken) throws Exception {
        GetPropertiesRequest req = new GetPropertiesRequest();
        req.setSessionToken(sessionToken);
        req.setType(type);
        String[] props = this.rrs.getProperties(req).getProperties();
        if (props == null) {
            return new String[0];
        }
        return props;
    }

    public boolean isFlowControled(String sessionToken) throws Exception {
        return this.rrs.isFlowControled(sessionToken);
    }

    public boolean getNextPart(int time, String sessionToken) throws Exception {
        GetNextPartRequest req = new GetNextPartRequest();
        req.setMaxWaitTime(time);
        req.setSessionToken(sessionToken);
        return this.rrs.getNextPart(req);
    }

    public boolean nextAvailable(String sessionToken) throws Exception {
        return this.rrs.nextAvailable(sessionToken);
    }

    public boolean getPreviousPart(String sessionToken) throws Exception {
        return this.rrs.getPreviousPart(sessionToken);
    }

    public boolean getFirstPart(String sessionToken) throws Exception {
        return this.rrs.getFirstPart(sessionToken);
    }

    public String retrieveCustomProperties(String sessionToken) throws Exception {
        return this.rrs.retrieveCustomProperties(sessionToken);
    }

    public boolean isFirst(String sessionToken) throws Exception {
        return this.rrs.isFirst(sessionToken);
    }

    public boolean isLast(String sessionToken) throws Exception {
        return this.rrs.isLast(sessionToken);
    }

    public int getNumberOfResults(String type, String sessionToken) throws Exception {
        GetNumberOfResultsRequest req = new GetNumberOfResultsRequest();
        req.setSessionToken(sessionToken);
        req.setType(type);
        return this.rrs.getNumberOfResults(req);
    }

    public String getResult(int index, String sessionToken) throws Exception {
        GetResultRequest req = new GetResultRequest();
        req.setIndex(index);
        req.setSessionToken(sessionToken);
        return this.rrs.getResult(req);
    }

    public String[] getAllResults(String sessionToken) throws Exception {
        return this.rrs.getAllResults(sessionToken).getResults();
    }

    public String[] getResults(int from, int to, String sessionToken) throws Exception {
        GetResultsRequest params = new GetResultsRequest();
        params.setFrom(from);
        params.setTo(to);
        params.setSessionToken(sessionToken);
        String[] res = this.rrs.getResults(params).getResults();
        if (res == null) {
            return new String[0];
        }
        return res;
    }

    public String canAttach(String sessionToken) throws Exception {
        log.error((Object)"Could not get attached content. Throwing Exception");
        throw new Exception("Could not get attached content");
    }

    public String[] splitEncoded(String sessionToken) throws Exception {
        return this.rrs.splitEncoded(this.locator.getSessionToken()).getPages();
    }

    public String[] splitClear(String sessionToken) throws Exception {
        return this.rrs.splitClear(sessionToken).getPages();
    }

    public String executeQueryOnDocument(String xPath, String sessionToken) throws Exception {
        ExecuteQueryOnDocumentRequest req = new ExecuteQueryOnDocumentRequest();
        req.setSessionToken(sessionToken);
        req.setXPath(xPath);
        return this.rrs.executeQueryOnDocument(req);
    }

    public String executeQueryOnHead(String xPath, String sessionToken) throws Exception {
        ExecuteQueryOnHeadRequest req = new ExecuteQueryOnHeadRequest();
        req.setSessionToken(sessionToken);
        req.setXPath(xPath);
        return this.rrs.executeQueryOnHead(req);
    }

    public String[] executeQueryOnResults(String xPath, String sessionToken) throws Exception {
        ExecuteQueryOnResultsRequest req = new ExecuteQueryOnResultsRequest();
        req.setSessionToken(sessionToken);
        req.setXPath(xPath);
        String[] ret = this.rrs.executeQueryOnResults(req).getResults();
        if (ret == null) {
            return new String[0];
        }
        return ret;
    }

    public String getHostIP(String sessionToken) throws Exception {
        return this.rrs.getHostIP(sessionToken);
    }

    public String getHostName(String sessionToken) throws Exception {
        return this.rrs.getHostName(sessionToken);
    }

    public String getFileContent(String filename, String sessionToken) throws Exception {
        GetFileContentRequest req = new GetFileContentRequest();
        req.setFilename(filename);
        req.setSessionToken(sessionToken);
        return this.rrs.getFileContent(req);
    }

    public String getCurrentContentPartPayload(String sessionToken) throws Exception {
        return this.rrs.getCurrentContentPartPayload(sessionToken);
    }

    public String transformByXSLT(String transformation, String sessionToken) throws Exception {
        TransformByXSLTRequest req = new TransformByXSLTRequest();
        req.setSessionToken(sessionToken);
        req.setTransformation(transformation);
        return this.rrs.transformByXSLT(req);
    }

    public String filterRSProp(String xPath, String[] properties, String sessionToken) throws Exception {
        FilterRSPropRequest params = new FilterRSPropRequest();
        params.setProperties(properties);
        params.setXpath(xPath);
        params.setSessionToken(this.locator.getSessionToken());
        return this.rrs.filterRSProp(params);
    }

    public String filterRS(String xPath, String sessionToken) throws Exception {
        FilterRSRequest req = new FilterRSRequest();
        req.setXpath(xPath);
        req.setSessionToken(sessionToken);
        return this.rrs.filterRS(req);
    }

    public String transformRSProp(String xslt, String[] properties, String sessionToken) throws Exception {
        TransformRSPropRequest params = new TransformRSPropRequest();
        params.setProperties(properties);
        params.setXslt(xslt);
        params.setSessionToken(sessionToken);
        return this.rrs.transformRSProp(params);
    }

    public String transformRS(String xslt, String sessionToken) throws Exception {
        TransformRSRequest req = new TransformRSRequest();
        req.setTransformation(xslt);
        req.setSessionToken(sessionToken);
        return this.rrs.transformRS(req);
    }

    public String keepTopProp(int count, String[] properties, short type, String sessionToken) throws Exception {
        KeepTopPropRequest params = new KeepTopPropRequest();
        params.setProperties(properties);
        params.setCount(count);
        params.setType(type);
        params.setSessionToken(this.locator.getSessionToken());
        return this.rrs.keepTopProp(params);
    }

    public String keepTop(int count, short type, String sessionToken) throws Exception {
        KeepTopRequest params = new KeepTopRequest();
        params.setCount(count);
        params.setType(type);
        params.setSessionToken(sessionToken);
        return this.rrs.keepTop(params);
    }

    public String cloneRS(String sessionToken) throws Exception {
        return this.rrs.cloneRS(sessionToken);
    }

    public String getCurrentContentPartName(String sessionToken) throws Exception {
        return this.rrs.getCurrentContentPartName(sessionToken);
    }

    public boolean isForward(String sessionToken) throws Exception {
        return this.rrs.isForward(sessionToken);
    }

    public int getAccessLeasing(String sessionToken) throws Exception {
        return this.rrs.getAccessLeasing(sessionToken);
    }

    public Date getTimeLeasing(String sessionToken) throws Exception {
        return new Date(this.rrs.getTimeLeasing(sessionToken));
    }
}

