/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.searchlibrary.rsclient.elements;

import java.util.Calendar;
import org.apache.log4j.Logger;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.Transporter;
import org.gcube.common.searchservice.searchlibrary.rsreader.RSReader;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSFullWriter;

public class MakeLocalThreadGeneric
extends Thread {
    public static Logger log = Logger.getLogger(MakeLocalThreadGeneric.class);
    public static short ENCODED = 0;
    public static short CLEAR = 1;
    private RSFullWriter writer = null;
    private RSReader reader = null;
    private int type = ENCODED;
    private int waittime = 300000;
    private int port = -1;
    private boolean SSLsupport = true;

    public MakeLocalThreadGeneric(RSFullWriter writer, RSReader reader, short type, int port, boolean SSLsupport) {
        this.writer = writer;
        this.reader = reader;
        this.type = type != ENCODED && type != CLEAR ? (int)ENCODED : (int)type;
        this.port = port;
        this.SSLsupport = SSLsupport;
    }

    public MakeLocalThreadGeneric(RSFullWriter writer, RSReader reader, short type, int waittime, int port, boolean SSLsupport) {
        this.writer = writer;
        this.reader = reader;
        this.type = type != ENCODED && type != CLEAR ? (int)ENCODED : (int)type;
        this.waittime = waittime;
        this.port = port;
        this.SSLsupport = SSLsupport;
    }

    @Override
    public void run() {
        log.info((Object)"run a MakeLocal Thread.");
        try {
            long startLocal = Calendar.getInstance().getTimeInMillis();
            try {
                if (this.reader.isSecure()) {
                    log.info((Object)"RS is secure.");
                }
                Transporter.transportStream(this.reader, this.writer, this.port, this.SSLsupport);
                log.info((Object)("Localization completed in " + (Calendar.getInstance().getTimeInMillis() - startLocal) + " millis"));
                return;
            }
            catch (Exception e) {
                log.error((Object)"could not complete streamed localization.", (Throwable)e);
                int count = 0;
                while (true) {
                    ++count;
                    String decodedFile = null;
                    try {
                        decodedFile = this.type == ENCODED ? Transporter.transportEncoded(this.reader) : Transporter.transportClear(this.reader);
                    }
                    catch (Exception e2) {
                        log.error((Object)"Could not localize current content part. Continuing", (Throwable)e2);
                    }
                    this.writer.wrapFile(decodedFile);
                    if (count == 1) {
                        log.info((Object)("first chunk available in " + (Calendar.getInstance().getTimeInMillis() - startLocal) + " millis"));
                    }
                    if (!this.reader.getNextPart(this.waittime)) break;
                    this.writer.startNewPart();
                }
                this.writer.endAuthoring();
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not end localization procedure.Ending Authoring", (Throwable)e);
            try {
                this.writer.endAuthoring();
            }
            catch (Exception ee) {
                log.error((Object)"Could not end Authoring", (Throwable)ee);
            }
        }
    }
}

